//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include <CanderaPlatform/Device/Common/Internal/GL/GlFrameBufferProperties.h>
#include <Candera/System/Diagnostics/Log.h>

namespace Candera
{
FEATSTD_LOG_SET_REALM(Diagnostics::LogRealm::CanderaPlatformDevice);

GlFrameBufferProperties::GlFrameBufferProperties() :
    Base(128, 128),
    m_msaaSamples(1)
{
}

GlFrameBufferProperties::GlFrameBufferProperties(const GlFrameBufferFormatProperties& base) :
    Base(base, 128, 128),
    m_msaaSamples(1)
{
}

void GlFrameBufferProperties::SetMsaaSamples(Int samples) {
    m_msaaSamples = samples;
#ifndef CGIDEVICE_OPENGLES_30
    FEATSTD_LOG_WARN("MSAA for offscreen render targets is not supported in this build configuration.");
#endif
}

} //namespace Candera

