//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################


#if !defined(SURFACE_ALLOCATOR_2D_OVER_3D_H_H)
#define SURFACE_ALLOCATOR_2D_OVER_3D_H_H

#include <Candera/Engine3D/Core/TextureImage.h>

#include <CanderaPlatform/Device/Common/Base/RenderDevice2D.h>
#include <CanderaPlatform/Device/Common/Internal/SurfaceAllocator.h>

namespace Candera {
    namespace Internal {

/**
 * @brief Class used to handle surfaces within the RenderDevice 2D over 3D.
 * 
 * This class is used internally by RenderDevice2D.
 */
    class SurfaceAllocator2DOver3D
    {
    public:
        typedef MemoryManagement::SharedPointer<TextureImage> TextureImagePointer;

        /**
         * @brief Class abstracting the interface of each surface.
         */
        struct SurfaceInfo
        {
            /**
             * Constructor.
             */
            SurfaceInfo();

            /**
             *  Texture image of this surface.
             */
            TextureImagePointer textureImage;

            // Additional information.
            ///> Pack order is used to determine whether to flip images.
            RenderDevice2D::PackOrder packOrder;
            ///> Color format is used to determine the use of alpha only images.
            Int pixelFormat;

            /**
             * Clear the surface info. Function required by SurfaceAllocator.
             * @return Always true.
             */
            bool Clear();
        };

        /**
         * Retrieve the singleton surface allocator.
         * @return A reference to the singleton surface allocator.
         */
        static SurfaceAllocator2DOver3D& GetInstance();

        /**
         * Retrieve the texture image behind a surface handle.
         * @param surface Handle of the surface.
         * @return A shared pointer to the texture image.
         */
        static TextureImagePointer GetTextureImage(SurfaceHandle surface);

        /**
         * Checks whether there is a texture image behind a surface handle.
         * @param surface Handle of the surface.
         * @return true, if the handle points to a texture image.
         */
        static bool HasTextureImage(SurfaceHandle surface);

        /**
         * Retrieve the surface allocator.
         * @return A reference to the surface allocator.
         */
        SurfaceAllocator<SurfaceInfo>& GetBase() { return m_base; }

    private:
        SurfaceAllocator2DOver3D() {}
        SurfaceAllocator<SurfaceInfo> m_base;
    };

}} // Name spaces.

#endif //SURFACE_ALLOCATOR_2D_OVER_3D_H_H
