//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################


#if !defined(GEOMETRY_ALLOCATOR_2D_OVER_3D_H_H)
#define GEOMETRY_ALLOCATOR_2D_OVER_3D_H_H

#include <Candera/Engine3D/Core/VertexBuffer.h>

#include <CanderaPlatform/Device/Common/Base/RenderDevice2D.h>
#include <CanderaPlatform/Device/Common/Internal/GeometryAllocator.h>

namespace Candera {
    namespace Internal {

        /**
        * @brief Class used to handle geometries within the RenderDevice 2D over 3D.
        *
        * This class is used internally by RenderDevice2D.
        */
        class GeometryAllocator2DOver3D
        {
        public:
            typedef VertexBuffer::SharedPointer VertexBufferPointer;

            /**
            * @brief Class abstracting the interface of each Geometry.
            */
            struct GeometryInfo
            {
                /**
                * Constructor.
                */
                GeometryInfo();

                /**
                *  VertexBuffer of this Geometry.
                */
                VertexBufferPointer vertexBuffer;

                /**
                * Clear the geometry info. Function required by GeometryAllocator.
                * @return Always true.
                */
                bool Clear();
            };

            /**
            * Retrieve the singleton geometry allocator.
            * @return A reference to the singleton geometry allocator.
            */
            static GeometryAllocator2DOver3D& GetInstance();

            /**
            * Retrieve the VertexBuffer behind a geometry handle.
            * @param geometry Handle of the geometry.
            * @return A shared pointer to the texture image.
            */
            static VertexBufferPointer GetVertexBuffer(GeometryHandle geometry);

            /**
            * Checks whether there is a VertexBuffer behind a geometry handle.
            * @param surface Handle of the geometry.
            * @return true, if the handle points to a VertexBUffer.
            */
            static bool HasVertexBuffer(GeometryHandle geometry);

            /**s
            * Retrieve the geometry allocator.
            * @return A reference to the geometry allocator.
            */
           GeometryAllocator<GeometryInfo>& GetBase() { return m_base; }

        private:
            GeometryAllocator2DOver3D() {}
            GeometryAllocator<GeometryInfo> m_base;
    };

    }
} // Name spaces.


#endif //GEOMETRY_ALLOCATOR_2D_OVER_3D_H_H
