//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "GeometryAllocator2DOver3D.h"
#include <FeatStd/Util/StaticObject.h>

namespace Candera {
    namespace Internal {

        static GeometryAllocator2DOver3D& s_forceInit = GeometryAllocator2DOver3D::GetInstance();

        GeometryAllocator2DOver3D& GeometryAllocator2DOver3D::GetInstance()
        {
            FEATSTD_UNSYNCED_STATIC_OBJECT(GeometryAllocator2DOver3D, s_instance);
            return s_instance;
        }

        GeometryAllocator2DOver3D::VertexBufferPointer GeometryAllocator2DOver3D::GetVertexBuffer(GeometryHandle geometry)
        {
           GeometryInfo* geometryInfo = GeometryAllocator2DOver3D::GetInstance().GetBase().GetDataFromGeometryHandle(geometry);
            if (geometryInfo != 0) {
                return geometryInfo->vertexBuffer;
            }
            return VertexBufferPointer();
        }

        bool GeometryAllocator2DOver3D::HasVertexBuffer(GeometryHandle geometry)
        {
            GeometryInfo* geometryInfo = GeometryAllocator2DOver3D::GetInstance().GetBase().GetDataFromGeometryHandle(geometry);
            return (geometryInfo != 0) && (!geometryInfo->vertexBuffer.PointsToNull());
        }

        GeometryAllocator2DOver3D::GeometryInfo::GeometryInfo()
        {
        }

        bool GeometryAllocator2DOver3D::GeometryInfo::Clear()
        {
            bool success = true;
            if (vertexBuffer != 0) {
                success = vertexBuffer->Unload(DeviceObject::ForceAll);
                vertexBuffer.Release();
            }

            return success;
        }

    }
}
