//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_GL_RADIAL_GRADIENT_BRUSH_BLEND_H)
#define CANDERA_GL_RADIAL_GRADIENT_BRUSH_BLEND_H

#include <Candera/Engine2D/Effects/CombinedEffect2D.h>
#include <CanderaPlatform/Device/Common/Internal/RenderDevice2DOver3D/Effects/GlRadialGradientBrush.h>
#include <CanderaPlatform/Device/Common/Effects/BlendEffect.h>

namespace Candera {

    class Image2D;

    /**
     *  @brief  Output a rectangle filled with a radial gradient effect between two colors and blend it with the store buffer.
     *          Same as chaining (GlRadialGradientBrush + BlendEffect)
     *          @see Candera::GlRadialGradientBrush
     *          @see Candera::BlendEffect
     */
    class GlRadialGradientBrushBlend : public CombinedEffect2D {
        FEATSTD_TYPEDEF_BASE(CombinedEffect2D);

    public:
        FEATSTD_TYPEDEF_SHARED_POINTER(GlRadialGradientBrushBlend);
        FEATSTD_RTTI_DECLARATION();

        /**
         *  Creates an instance of this class
         *  @return A pointer to the created object.
         */
        FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

        // overrides Effect2D::GetBrushEffect2D
        virtual BrushEffect2D* GetBrushEffect2D() override { return &m_gradientBrush; }

        // overrides Effect2D::GetBlendEffect2D
        virtual BlendEffect2D* GetBlendEffect2D() override { return &m_blendEffect; }

        // overrides Effect2D::Clone
        virtual Effect2D::SharedPointer Clone() const override;

        /**
        * Mesh2D cannot be supported by all effects, as certain effects would create 2D vertex buffers, which would be overriden by the Mesh2D.
        * This flag helps to distinguish between effects that can be used with Mesh2D and effects that are not available.
        * @return Whether Mesh2D can be used with this effect (true) or not (false).
        */
        virtual bool IsMesh2DSupported() const override { return true; }

        /// @cond excluded from doxygen
        CdaEffect2DCombinedDef(Candera::GlRadialGradientBrushBlend, GlRadialGradientBrushBlend,  EFFECT2D_TYPE_BRUSH, EFFECT2D_TYPE_BLEND)
            CdaEffect2DProperties()

            CdaEffect2DImportProperties(GlRadialGradientBrush, Candera::GlRadialGradientBrush, m_gradientBrush)
                CdaEffect2DImportProperties(BlendEffect, Candera::BlendEffect, m_blendEffect)

            CdaEffect2DPropertiesEnd()
        CdaEffect2DDefEnd()
        /// @endcond

    protected:
        // Explicit protected Constructor Copy-Constructor and destructor, use Create() to create an instance of this object.
        GlRadialGradientBrushBlend();
        explicit GlRadialGradientBrushBlend(const GlRadialGradientBrushBlend& rhs);
        virtual ~GlRadialGradientBrushBlend();
        GlRadialGradientBrushBlend& operator = (const GlRadialGradientBrushBlend& rhs);

        // overrides Effect2D::Render
        virtual void Render(SurfaceHandle input, const Rectangle& inputArea, const Matrix3x2& transform, const Node2D& node, ContextHandle2D output, Rectangle& outputArea) override;

    private:
        // Use class wrapper to forward protected members.
        class GlRadialGradientBrushWrapper : public GlRadialGradientBrush {} m_gradientBrush;
        class BlendEffectWrapper : public BlendEffect {} m_blendEffect;
    };

}   // namespace Candera

#endif  // CANDERA_GL_RADIAL_GRADIENT_BRUSH_BLEND_H
