//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "GlFlipBitmapBrushBlend.h"
#include <Candera/System/Monitor/PerfMonPublicIF.h>

namespace Candera {
    FEATSTD_RTTI_DEFINITION(GlFlipBitmapBrushBlend, CombinedEffect2D)

    /******************************************************************************
     *  Constructor
     ******************************************************************************/
    GlFlipBitmapBrushBlend::GlFlipBitmapBrushBlend()
    {
    }

    GlFlipBitmapBrushBlend::GlFlipBitmapBrushBlend(const GlFlipBitmapBrushBlend& rhs) :
        Base(rhs),
        m_bitmapBrush(rhs.m_bitmapBrush),
        m_flipEffect(rhs.m_flipEffect),
        m_blendEffect(rhs.m_blendEffect)
    {
    }

    /******************************************************************************
     *  Destructor
     ******************************************************************************/
    GlFlipBitmapBrushBlend::~GlFlipBitmapBrushBlend()
    {
    }

    /******************************************************************************
     *  Create
     ******************************************************************************/
    GlFlipBitmapBrushBlend::SharedPointer GlFlipBitmapBrushBlend::Create()
    {
        CANDERA_SUPPRESS_LINT_FOR_CURRENT_SCOPE(429, CANDERA_LINT_REASON_SHAREDPOINTER)

        GlFlipBitmapBrushBlend* brush = FEATSTD_NEW(GlFlipBitmapBrushBlend);
        FEATSTD_DEBUG_ASSERT(brush != 0);

        GlFlipBitmapBrushBlend::SharedPointer sharedPtr(brush);
        return sharedPtr;
    }

    /******************************************************************************
     *  Upload
     ******************************************************************************/
    bool GlFlipBitmapBrushBlend::Upload()
    {
        bool success = m_bitmapBrush.Upload();
        success = success && m_flipEffect.Upload();
        success = success && m_blendEffect.Upload();
        return success;
    }

    /******************************************************************************
     *  Unload
     ******************************************************************************/
    bool GlFlipBitmapBrushBlend::Unload()
    {
        bool success = m_bitmapBrush.Unload();
        success = success && m_flipEffect.Unload();
        success = success && m_blendEffect.Unload();
        return success;
    }

    /******************************************************************************
     *  Update
     ******************************************************************************/
    bool GlFlipBitmapBrushBlend::Update()
    {
        bool success = m_bitmapBrush.Update();
        success = success && m_flipEffect.Update();
        success = success && m_blendEffect.Update();
        return success;
    }

    /******************************************************************************
     *  Render
     ******************************************************************************/
    void GlFlipBitmapBrushBlend::Render(SurfaceHandle input, const Rectangle& inputArea, const Matrix3x2& transform,
                                           const Node2D& node, ContextHandle2D output, Rectangle& outputArea)
    {
        CANDERA_PERF_RECORDER(Timing, (FeatStd::PerfMon::TimingRecId::RenderEffect2D, "GlFlipBitmapBrushBlend"));

        if (m_bitmapBrush.Image() != 0) {
            m_blendEffect.ActivateBlend(output);
            m_flipEffect.ActivateFlip(output);
            m_bitmapBrush.Render(input, inputArea, transform, node, output, outputArea);
            m_flipEffect.DeactivateFlip(output);
            m_blendEffect.DeactivateBlend(output);
        }
    }

    /******************************************************************************
     *  Clone
     ******************************************************************************/
    Effect2D::SharedPointer GlFlipBitmapBrushBlend::Clone() const
    {
        return Effect2D::SharedPointer(CANDERA_NEW(GlFlipBitmapBrushBlend)(*this));
    }

}   // namespace Candera

