//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "GlFlipBitmapBrush.h"

#include <CanderaPlatform/Device/Common/Internal/RenderDevice2DOver3D/RenderDevice2DOver3D.h>
#include <Candera/Engine2D/Core/Renderer2D.h>
#include <Candera/System/Monitor/PerfMonPublicIF.h>

namespace Candera {
    FEATSTD_RTTI_DEFINITION(GlFlipBitmapBrush, CombinedEffect2D)

    /******************************************************************************
     *  Constructor
     ******************************************************************************/
    GlFlipBitmapBrush::GlFlipBitmapBrush() :
        Base()
    {
    }

    GlFlipBitmapBrush::GlFlipBitmapBrush(const GlFlipBitmapBrush& rhs) :
        Base(rhs),
        m_bitmapBrush(rhs.m_bitmapBrush),
        m_flipEffect(rhs.m_flipEffect)
    {
    }

    /******************************************************************************
     *  Destructor
     ******************************************************************************/
    GlFlipBitmapBrush::~GlFlipBitmapBrush()
    {
    }

    /******************************************************************************
     *  Upload
     ******************************************************************************/
    bool GlFlipBitmapBrush::Upload()
    {
        bool success = m_bitmapBrush.Upload();
        success = success && m_flipEffect.Upload();
        return success;
    }
    /******************************************************************************
     *  Unload
     ******************************************************************************/
    bool GlFlipBitmapBrush::Unload()
    {
        bool success = m_bitmapBrush.Unload();
        success = success && m_flipEffect.Unload();
        return success;
    }
    /******************************************************************************
     *  Update
     ******************************************************************************/
    bool GlFlipBitmapBrush::Update()
    {
        bool success = m_bitmapBrush.Update();
        success = success && m_flipEffect.Update();
        return success;
    }

    /******************************************************************************
     *  Create
     ******************************************************************************/
    GlFlipBitmapBrush::SharedPointer GlFlipBitmapBrush::Create()
    {
        CANDERA_SUPPRESS_LINT_FOR_CURRENT_SCOPE(429, CANDERA_LINT_REASON_SHAREDPOINTER)

        GlFlipBitmapBrush* brush = FEATSTD_NEW(GlFlipBitmapBrush);
        FEATSTD_DEBUG_ASSERT(brush != 0);

        GlFlipBitmapBrush::SharedPointer sharedPtr(brush);
        return sharedPtr;
    }

    /******************************************************************************
     *  Render
     ******************************************************************************/
    void GlFlipBitmapBrush::Render(SurfaceHandle input, const Rectangle& inputArea, const Matrix3x2& transform, const Node2D& node,
                                 ContextHandle2D output, Rectangle& outputArea)
    {
        CANDERA_PERF_RECORDER(Timing, (FeatStd::PerfMon::TimingRecId::RenderEffect2D, "GlFlipBitmapBrush"));

        if (m_bitmapBrush.Image() != 0) {
            m_flipEffect.ActivateFlip(output);
            m_bitmapBrush.Render(input, inputArea, transform, node, output, outputArea);
            m_flipEffect.DeactivateFlip(output);
        }
    }

    /******************************************************************************
     *  Clone
     ******************************************************************************/
    Effect2D::SharedPointer GlFlipBitmapBrush::Clone() const
    {
        return Effect2D::SharedPointer(CANDERA_NEW(GlFlipBitmapBrush)(*this));
    }

}   // namespace Candera

