//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_DROPSHADOW_BITMAPBRUSHCOLORBLEND_H)
#define CANDERA_DROPSHADOW_BITMAPBRUSHCOLORBLEND_H

#include <Candera/Engine2D/Effects/CombinedEffect2D.h>
#include <CanderaPlatform/Device/Common/Effects/BitmapBrush.h>
#include <CanderaPlatform/Device/Common/Effects/ColorEffect.h>
#include <CanderaPlatform/Device/Common/Internal/RenderDevice2DOver3D/Effects/GlDropShadowEffect.h>
#include <CanderaPlatform/Device/Common/Effects/BlendEffect.h>

namespace Candera {

    /** @brief    This effect creates a shadow of the corresponding bitmap image and blends it with the stored buffer.
     *            Same as chaining (BitmapBrush + ColorEffect + GlDropShadowEffect + BlendEffect)
     *            @see Candera::BitmapBrush
     *            @see Candera::ColorEffect
     *            @see Candera::GlDropShadowEffect
     *            @see Candera::BlendEffect
     */
    class GlDropShadowBitmapBrushColorBlend : public CombinedEffect2D {
        FEATSTD_TYPEDEF_BASE(CombinedEffect2D);

    public:
        FEATSTD_TYPEDEF_SHARED_POINTER(GlDropShadowBitmapBrushColorBlend);
        // FEATSTD_RTTI_DECLARATION();
        CANDERA_RTTI_DECLARATION(Candera::GlDropShadowBitmapBrushColorBlend);

        /**
         *  Creates an instance of this class
         *  @return A pointer to the created object.
         */
        FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

        /**
         *  Retrieves the bitmap brush.
         *  @return     The bitmap brush.
         */
        const BitmapBrush& GetBitmapBrush() const { return m_bitmapBrush; }
        BitmapBrush& GetBitmapBrush() { return m_bitmapBrush; }

        /**
         *  Retrieves the dropshadow effect.
         *  @return     The dropshadow effect.
         */
        const GlDropShadowEffect& GetDropShadowEffect() const { return m_dropShadowEffect; }
        GlDropShadowEffect& GetDropShadowEffect() { return m_dropShadowEffect; }

        /**
        *  Retrieves the color effect.
        *  @return     The color effect.
        */
        const ColorEffect& GetColorEffect() const { return m_colorEffect; }
        ColorEffect& GetColorEffect() { return m_colorEffect; }

        /**
         *  Retrieves the blend effect.
         *  @return     The blend effect.
         */
        const BlendEffect& GetBlendEffect() const { return m_blendEffect; }
        BlendEffect& GetBlendEffect() { return m_blendEffect; }


        // overrides Effect2D::GetBrushEffect2D
        virtual BrushEffect2D* GetBrushEffect2D() override { return &m_bitmapBrush; }

        // overrides Effect2D::GetInplaceEffect2DCount
        virtual UInt8 GetInPlaceEffect2DCount() const { return 2; }

        // overrides Effect2D::GetInPlaceEffect2D
        virtual InPlaceEffect2D* GetInPlaceEffect2D(UInt8 index);

        // overrides Effect2D::GetBlendEffect2D
        virtual BlendEffect2D* GetBlendEffect2D() override { return &m_blendEffect; }

        // overrides Effect2D::Upload
        virtual bool Upload();

        // overrides Effect2D::Unload
        virtual bool Unload();

        // overrides Effect2D::Update
        virtual bool Update();

        // overrides Effect2D::Clone
        virtual Effect2D::SharedPointer Clone() const override;

        
        virtual void GetBoundingRectangle(Rectangle& boundingRectangle) const override;
        virtual void GetLayoutingRectangle(Rectangle& rectangle) const override;

        /// @cond excluded from doxygen
        CdaEffect2DCombinedDef(Candera::GlDropShadowBitmapBrushColorBlend, GlDropShadowBitmapBrushColorBlend, EFFECT2D_TYPE_BRUSH, EFFECT2D_TYPE_BLEND)

            CdaDescription("This effect casts a shadow of the coresponding bitmap image and blend it with the store buffer.")
            CdaEffect2DProperties()

                 CdaEffect2DImportProperties(GlBitmapBrush, Candera::BitmapBrush, m_bitmapBrush)
                 CdaEffect2DImportProperties(GlDropShadowEffect, Candera::GlDropShadowEffect, m_dropShadowEffect)
                 CdaEffect2DImportProperties(ColorEffect, Candera::ColorEffect, m_colorEffect)
                 CdaEffect2DImportProperties(BlendEffect, Candera::BlendEffect, m_blendEffect)

            CdaEffect2DPropertiesEnd()
        CdaEffect2DDefEnd()
        /// @endcond

    protected:
        // Explicit protected Constructor and Copy-Constructor, use Create() to create an instance of this object.
        GlDropShadowBitmapBrushColorBlend();
        explicit GlDropShadowBitmapBrushColorBlend(const GlDropShadowBitmapBrushColorBlend& rhs);
        virtual ~GlDropShadowBitmapBrushColorBlend();
        GlDropShadowBitmapBrushColorBlend& operator = (const GlDropShadowBitmapBrushColorBlend& rhs);

        // overrides Effect2D::Render
        virtual void Render(SurfaceHandle input, const Rectangle& inputArea, const Matrix3x2& transform, const Node2D& node, ContextHandle2D output, Rectangle& outputArea) override;

    private:
         // Use class wrappers to forward protected members.
        class BitmapBrushWrapper : public BitmapBrush {} m_bitmapBrush;
        class GlDropShadowEffectWrapper: public GlDropShadowEffect {
            public:
                using GlDropShadowEffect::Render;
        } m_dropShadowEffect;
        class ColorEffectWrapper : public ColorEffect {} m_colorEffect;
        class BlendEffectWrapper : public BlendEffect {} m_blendEffect;
    };

}   // namespace Candera

#endif  // CANDERA_DROPSHADOW_BITMAPBRUSHCOLORBLEND_H

