//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "GraphicDeviceUnitOwnerAccess.h"
#include <CanderaPlatform/Device/Common/Base/GraphicDeviceUnit.h>

namespace Candera {
    namespace Internal {

GraphicDeviceUnitOwnerAccess::GraphicDeviceUnitOwnerAccess(GraphicDeviceUnit* hostGdu) :
    m_ownerType(NoOwner),
    m_camera(0)
{
    this->operator = (hostGdu->GetOwnerAccess());
}

ContextResourcePool* GraphicDeviceUnitOwnerAccess::GetContextResourcePoolOwner() const
{
    return (m_ownerType == ContextResourcePoolOwner) ? m_crp : 0;
}

GraphicDeviceUnit* GraphicDeviceUnitOwnerAccess::GetGraphicDeviceUnitOwner() const
{
    return (m_ownerType == GraphicDeviceUnitOwner) ? m_gdu : 0;
}

void GraphicDeviceUnitOwnerAccess::SetGraphicDeviceUnitOwner(GraphicDeviceUnit* host, RenderTarget3D* owner)
{
    host->SetOwner(owner);
}

GraphicDeviceUnitOwnerAccess::GraphicDeviceUnitOwnerAccess() :
    m_ownerType(NoOwner),
    m_camera(0)
{
}
GraphicDeviceUnitOwnerAccess::GraphicDeviceUnitOwnerAccess(GraphicDeviceUnit* gdu, Camera* camera) :
    m_ownerType(GraphicDeviceUnitOwner),
    m_gdu(gdu),
    m_camera(camera)
{
}
GraphicDeviceUnitOwnerAccess::GraphicDeviceUnitOwnerAccess(ContextResourcePool* crp, Camera* camera) :
    m_ownerType(ContextResourcePoolOwner),
    m_crp(crp),
    m_camera(camera)
{
}

    }
}
