//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_GEOMETRY_ALLOCATOR_H)
#define CANDERA_GEOMETRY_ALLOCATOR_H

#include <Candera/Environment.h>
#include <CanderaPlatform/Device/Common/Base/RenderDevice2D.h>
#include <CanderaPlatform/Device/Common/Internal/AllocatorBase.h>

namespace Candera {
    /**
    * @brief GeometryAllocator is a helper class intended to handle generic tasks involved in
    * surface allocation.
    *
    * @param TInfo Defines the platform specific type of the stored surface data.
    **/
    template<typename TInfo>
    class GeometryAllocator : public AllocatorBase<TInfo, GeometryHandle>
    {
        FEATSTD_LINT_SYMBOL(1516, *(AllocatorBase<TInfo, GeometryHandle>), "Typedef to Base is used in a derived class to access its base class by standard term.");
        typedef AllocatorBase<TInfo, GeometryHandle> Base;

    public:

        virtual ~GeometryAllocator() override
        {
        }

        bool CreateGeometries(Int count, GeometryHandle *pSurface)
        {
            return Base::CreateItems(count, pSurface);
        }

        bool DestroyGeometries(Int count, GeometryHandle *pSurface)
        {
            return Base::DestroyItems(count, pSurface);
        }

        static TInfo* GetDataFromGeometryHandle(GeometryHandle surface)
        {
            return Base::GetDataFromItemHandle(surface);
        }
    };
} // namespace Candera
#endif //CANDERA_SurfaceAllocator_H
