//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################


#if !defined(GL_SIMPLE_WARPING_MESH_H)
#define GL_SIMPLE_WARPING_MESH_H

#include <CanderaPlatform/Device/Common/Base/WarpMatrix.h>
#include <CanderaPlatform/Device/Common/OpenGLES/GlInclude.h>

namespace Candera
{
    class Rectangle;

/** @addtogroup CommonDevice
 *  @{
 */

/**
 * @brief GlSimpleWarpingMesh is a class that creats an Open GL mesh out of a WarpMatrix.
 */
    class GlSimpleWarpingMesh
    {
        public:
            /**
             * Constructor
             */
            GlSimpleWarpingMesh();

            /**
             * Destructor
             */
            ~GlSimpleWarpingMesh();

            /**
             * Create the mesh and upload it to video memory.
             * @param src Source warping matrix.
             * @return True if the upload was successful. False otherwise.
             */
            bool Upload(WarpMatrix& src, const Rectangle& imageBounds);

            /**
             * Unload the mesh from the video memory.
             */
            void Unload();

            /**
             * Activate the warping mesh.
             */
            void Activate() const;

            /**
             * Draw the warping mesh.
             */
            void Draw() const;

            /**
             * Check whether the mesh has been uploaded.
             * @return True if the mesh has been successfully uploaded.
             */
            bool IsUploaded() const { return m_vertexBuffer != 0; }

        private:
            GLuint m_vertexBuffer;
            GLsizei m_drawCount;
    };

/** @}*/ //end of CommonDevice

}

#endif
