//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include <CanderaPlatform/Device/Common/Internal/GL/GlFlushSync.h>
#include <CanderaPlatform/Device/Common/Internal/EGL/EglContext.h>

#include <CanderaPlatform/Device/Common/OpenGLES/GlTrace.h>
#include <CanderaPlatform/Device/Common/OpenGLES/GlInclude.h>
#include <CanderaPlatform/Device/Common/EGL/EglTraceMapper.h>

#include <CanderaPlatform/Device/Common/Base/ImageSource3D.h>
#include <CanderaPlatform/Device/Common/EGL/EglWrapper.h>

namespace Candera
{
    using namespace Internal;

GlFlushSync::GlFlushSync()
{
}

GlFlushSync::~GlFlushSync()
{
}

void GlFlushSync::WaitSync(EglContext& contextProvider) const
{
    // Sync might be called also while not active (between Begin and End). As such another context may be active
    // In this case we need to remember the current context
    EGLContext ownerCtx = contextProvider.GetContext();

    EGLContext ctx = EGLWrapper::GetInstance().GetCurrentContext();
    CANDERA_DEVICE_CHECK_AND_LOG_DEBUG(Egl, "EGLWrapper::GetInstance().GetCurrentContext");
    EGLDisplay disp = EGL_NO_DISPLAY;
    EGLSurface surfRead = EGL_NO_SURFACE;
    EGLSurface surfDraw = EGL_NO_SURFACE;

    bool activationSuccessful = true;

    if (ctx != ownerCtx) {
        disp = EGLWrapper::GetInstance().GetCurrentDisplay();
        surfRead = EGLWrapper::GetInstance().GetCurrentSurface(EGL_READ);
        surfDraw = EGLWrapper::GetInstance().GetCurrentSurface(EGL_DRAW);

        activationSuccessful = contextProvider.ActivateContext();
    }

    if (activationSuccessful) {
        glFinish();

        if (ctx != ownerCtx) {
            static_cast<void>(EGLWrapper::GetInstance().MakeCurrent(disp, surfDraw, surfRead, ctx));
            CANDERA_DEVICE_CHECK_AND_LOG_DEBUG(Egl, "EGLWrapper::GetInstance().MakeCurrent");
        }
    }
}

void GlFlushSync::Sync(EglContext& /*contextProvider*/) const
{
}

void GlFlushSync::WaitBeginDraw(EglContext& /*contextProvider*/) const
{
}

void GlFlushSync::MarkEndDraw(EglContext& /*contextProvider*/) const
{
}
}
