//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(GENERIC_IMAGE_SOURCE_3D_H)
#define GENERIC_IMAGE_SOURCE_3D_H

#include <CanderaPlatform/Device/Common/Base/ImageSource3D.h>
#include <CanderaPlatform/Device/Common/Internal/GDU/GduWrapper.h>

namespace Candera
{

/** @addtogroup CommonDevice
 *  @{
 */

/**
 * @brief Class GduWrapperImageSource3D provides dedicated interfaces to access a specific surface
 * as an image source.
 *
 * The class has one template parameter representing the specific type of surface which is
 * wrapped by this class. The specific type must implement the folowing methods:
 *  Int GetHeight() const;
 *  Int GetWidth() const;
 *  void Sync();
 *  void WaitSync();
 *  Handle GetImageHandle(Int index) const;
 * @param TWrappedType the type of the wrapper surface.
 */
 template <typename TWrappedType>
class GduWrapperImageSource3D : public ImageSource3D, public GduWrapper<TWrappedType>
{
    public:
        typedef GduWrapper<TWrappedType> Wrapper;

        GduWrapperImageSource3D() {}

        /**
         *  Destructs a GduWrapperImageSource3D object.
         */
        virtual ~GduWrapperImageSource3D() {}

        /**
         *  Returns current height of the surface. Overrides pure virtual function of class WrappedSurface.
         *  @return The current height of the surface.
         */
        virtual Int GetHeight() const { return (Wrapper::GetWrappedObject() == 0) ? 0 : Wrapper::GetWrappedObject()->GetHeight(); }

        /**
         *  Returns current width of the surface. Overrides pure virtual function of class WrappedSurface.
         *  @return the current width of the surface.
         */
        virtual Int GetWidth() const { return (Wrapper::GetWrappedObject() == 0) ? 0 : Wrapper::GetWrappedObject()->GetWidth(); }

        /**
         *  Overrides pure virtual function of class Synchronizable.
         */
        virtual void Sync() { (Wrapper::GetWrappedObject() == 0) ? (void)0 : Wrapper::GetWrappedObject()->Sync(); }

        /**
         *  Overrides pure virtual function of class Synchronizable.
         */
        virtual void WaitSync() { (Wrapper::GetWrappedObject() == 0) ? (void)0 : Wrapper::GetWrappedObject()->WaitSync(); }

        /**
         *  Overrides pure virtual function of class Synchronizable.
         */
        virtual void OnAccess() { (Wrapper::GetWrappedObject() == 0) ? (void)0 : Wrapper::GetWrappedObject()->OnAccess(); }

        /**
         *  Returns the image handle associated with this image source. Overrides pure virtual function of class ImageSource3D.
         *  @return the image handle associated with this image source.
         */
        virtual Handle GetVideoMemoryHandle() const { return (Wrapper::GetWrappedObject() == 0) ? 0 : Wrapper::GetWrappedObject()->GetImageHandle(Wrapper::GetIndex()); }

        /**
         *  Returns whether this image source enables mipmapping or not. Overrides pure virtual function of class ImageSource3D.
         *  @return True, whether this image source enables mipmapping, false otherwise.
         */
        virtual bool IsMipMappingEnabled() const { return false; }
};

/** @}*/ //end of CommonDevice

}

#endif
