//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(GENERIC_IMAGE_SOURCE_2D_H)
#define GENERIC_IMAGE_SOURCE_2D_H

#include <CanderaPlatform/Device/Common/Base/ImageSource2D.h>
#include <CanderaPlatform/Device/Common/Internal/GDU/GduWrapper.h>

namespace Candera
{

/** @addtogroup CommonDevice
 *  @{
 */

/**
 * @brief Class GduWrapperImageSource2D provides dedicated interfaces to access a specific surface
 * as an image source.
 *
 * The class has one template parameter representing the specific type of surface which is
 * wrapped by this class. The specific type must implement the folowing methods:
 *  Int GetHeight2D() const;
 *  Int GetWidth2D() const;
 *  void Sync2D();
 *  void WaitSync2D();
 *  Handle GetImage2DHandle(Int index) const;
 * @param TWrappedType the type of the wrapper surface.
 */
 template <typename TWrappedType>
class GduWrapperImageSource2D : public ImageSource2D, public GduWrapper<TWrappedType>
{
    public:
        typedef GduWrapper<TWrappedType> Wrapper;

        GduWrapperImageSource2D() {}

        /**
         *  Destructs a GduWrapperImageSource2D object.
         */
        virtual ~GduWrapperImageSource2D() {}

        /**
         *  Returns current height of the surface. Overrides pure virtual function of class WrappedSurface.
         *  @return The current height of the surface.
         */
        virtual Int GetHeight() const { return (Wrapper::GetWrappedObject() == 0) ? 0 : Wrapper::GetWrappedObject()->GetHeight2D(); }

        /**
         *  Returns current width of the surface. Overrides pure virtual function of class WrappedSurface.
         *  @return the current width of the surface.
         */
        virtual Int GetWidth() const { return (Wrapper::GetWrappedObject() == 0) ? 0 : Wrapper::GetWrappedObject()->GetWidth2D(); }

        /**
         *  Overrides pure virtual function of class Synchronizable.
         */
        virtual void Sync() { (Wrapper::GetWrappedObject() == 0) ? (void)0 : Wrapper::GetWrappedObject()->Sync2D(); }

        /**
         *  Overrides pure virtual function of class Synchronizable.
         */
        virtual void WaitSync() { (Wrapper::GetWrappedObject() == 0) ? (void)0 : Wrapper::GetWrappedObject()->WaitSync2D(); }

        /**
         *  Overrides pure virtual function of class Synchronizable.
         */
        virtual void OnAccess() { (Wrapper::GetWrappedObject() == 0) ? (void)0 : Wrapper::GetWrappedObject()->OnAccess2D(); }

        /**
         *  Returns the image handle associated with this image source. Overrides pure virtual function of class ImageSource2D.
         *  @return the image handle associated with this image source.
         */
        virtual SurfaceHandle GetSurfaceHandle() const { return (Wrapper::GetWrappedObject() == 0) ? 0 : Wrapper::GetWrappedObject()->GetImage2DHandle(Wrapper::GetIndex()); }
};

/** @}*/ //end of CommonDevice

}

#endif
