//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################


#if !defined(EGL_EXTENSIONPROCEDURERESULT_H)
#define EGL_EXTENSIONPROCEDURERESULT_H


#include <CanderaPlatform/Device/Common/EGL/EglInclude.h>


namespace Candera
{

/** @addtogroup CommonDevice
 *  @{
 */


/**
 * @brief Base class encapsulating EGL extension procedure call result of given Type.
 */
template<typename Type>
class EglExtensionProcedureResult
{
};


/**
 * @brief Specialization of class encapsulating void result of EGL extension procedure call.
 */
template<>
class EglExtensionProcedureResult<void>
{
public:
    // Construction

    EglExtensionProcedureResult<void>& operator=(const EGLImageKHR&) { return *this; }


    // Accessors

    bool IsErrorOrVoid() const { return true; }
};


/**
 * @brief Class with explicit specializations defining type traits of procedure results. 
 */
template<typename Type>
class EglExtensionProcedureResultTraits
{
public:
    static Type GetInvalidValue();
};

template<>
class EglExtensionProcedureResultTraits<EGLBoolean>
{
public:
    static EGLBoolean GetInvalidValue() { return false; }
};

template<>
class EglExtensionProcedureResultTraits<EGLImageKHR>
{
public:
    static EGLImageKHR GetInvalidValue() { return static_cast<void*>(0); }
};


/**
 * @brief Class encapsulating EglExtensionProcedureResult<Type> result of EGL extension procedure call, where Type is not void.
 */
template<typename Type>
class EglExtensionProcedureResultWithValue
{
public:
    // Construction

    EglExtensionProcedureResultWithValue() : m_value(EglExtensionProcedureResultTraits<Type>::GetInvalidValue()) { }


    // Operations

    operator Type() const { return m_value; }


    // Accessors

    bool IsErrorOrVoid() const { return m_value == EglExtensionProcedureResultTraits<Type>::GetInvalidValue(); }


protected:
    // Attributes

    Type m_value;
};


/**
 * @brief Specialization of class encapsulating EglExtensionProcedureResult<EGLBoolean> result of EGL extension procedure call.
 */
template<>
class EglExtensionProcedureResult<EGLBoolean> : public EglExtensionProcedureResultWithValue<EGLBoolean>
{
public:
    // Construction

    EglExtensionProcedureResult<EGLBoolean>& operator=(const EGLBoolean& right)
    {
        m_value = right;
        return *this;
    }
};


/**
 * @brief Specialization of class encapsulating EglExtensionProcedureResult<EGLImageKHR> result of EGL extension procedure call.
 */
template<>
class EglExtensionProcedureResult<EGLImageKHR> : public EglExtensionProcedureResultWithValue<EGLImageKHR>
{
public:
    // Construction

    EglExtensionProcedureResult<EGLImageKHR>& operator=(const EGLImageKHR& right)
    {
        m_value = right;
        return *this;
    }
};


/** @}*/ //end of CommonDevice

} // namespace Candera


#endif // defined(EGL_EXTENSIONPROCEDURERESULT_H)
