//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(EGL_CONTEXT_DELEGATOR_H)
#define EGL_CONTEXT_DELEGATOR_H

#include <CanderaPlatform/Device/Common/Base/ContextDelegator3D.h>
#include <CanderaPlatform/Device/Common/Internal/EGL/EglContext.h>
#include <CanderaPlatform/Device/Common/Internal/GDU/GduSupport.h>
#include <CanderaPlatform/Device/Common/Internal/GDU/GduProperties.h>

namespace Candera
{

/** @addtogroup CommonDevice
 *  @{
 */

/**
 * @brief EglContextDelegator represents a wrapper that links a ContextDelegator3D with an EglContext.
 *
 * Can be used as context in GduBaseRenderTarget.
 * As a ContextDelegator3D it delegates the requirements for the EglContext interface to the
 * ContextResourcePool.
 */
class EglContextDelegator : public ContextDelegator3D, public EglContext
{
    CANDERA_LINT_DECLARE_CLEANUP_FUNCTION(Candera::EglContextDelegator::Unload)

    public:

        /**
         *  Constructs a EglContextDelegator object.
         */
        EglContextDelegator() : m_mustReleasePool(false) {}

        /**
         *  Uploads this object to video memory.
         *  @param displayId         Display to which this render target is attached.
         *  @param support           Passed to Base.
         *  @param properties        Passed to Base.
         *  @return True if successful, false otherwise.
         */
        FEATSTD_LINT_NEXT_EXPRESSION(1511, "deliberate methode naming, overwrite of base class method not intended. ")
        bool Upload(Int displayId, GduSupport& support, GduProperties& properties);

        /**
         *  Unloads this object from video memory.
         */
        void Unload();

        /**
         *  Does nothing.
         *  @param properties        Unused.
         */
        void ApplyChanges(GduProperties& properties) const;

        /**
         *  Activates the associated context and sets up render state caching and
         *  the context resource pool.
         *  @return true if activation is successful
         */
        virtual bool Activate();

        /**
         *  Retrieves the associated context.
         *  @return handle of the associated EGLContext.
         */
        virtual EGLContext GetContext() const { return FeatStd::Internal::PointerToPointer<EGLContext>(ContextDelegator3D::GetContextHandle()); }

        /**
         * Make the a context from the associated context resource pool active.
         * @return True if successful, otherwise false.
         */
        bool ActivateContext() { return ContextDelegator3D::ActivateContext(); }

    protected:
        /**
         *  Non-virtual. An object should never be destroyed from a pointer to this class.
         */
        ~EglContextDelegator();

    private:
        bool m_mustReleasePool;
};

/** @}*/ //end of CommonDevice


}

#endif
