//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include <CanderaPlatform/Device/Common/Internal/EGL/EglContextCreator.h>

#include <CanderaPlatform/Device/Common/EGL/EglTraceMapper.h>

#if !defined(CGIDEVICE_OPENVG_101)
    #include <CanderaPlatform/Device/Common/OpenGLES/GlInclude.h>
#endif

namespace Candera
{

static FeatStd::EventSource& s_forcedEglContextCreatorEventSource = EglContextCreator::GetEventSource();

EglContextCreator::EglContextCreator() :
    m_context(EGL_NO_CONTEXT)
{
}

bool EglContextCreator::Upload(Int, const GduSupport&, const GduProperties&)
{
    static EGLint contextAttributes[] = { EGL_CONTEXT_CLIENT_VERSION, CANDERA_DEVICE_EGL_CONTEXT_CLIENT_VERSION, EGL_NONE };
    m_context =
        eglCreateContext(
            GetDisplay(),
            GetConfig(),
            GetShareContext(),
            contextAttributes);
    CANDERA_DEVICE_CHECK_AND_LOG_WARN(Egl, "eglCreateContext");

    EglContextCreator::AfterUploadEvent createEvent(m_context, GetShareContext());
    GetEventSource().DispatchEvent(createEvent);

    if (m_context == EGL_NO_CONTEXT) {
        return false;
    }

    return true;
}

void EglContextCreator::Unload()
{
    EglContextCreator::BeforeUnloadEvent destroyEvent(m_context, GetShareContext());
    GetEventSource().DispatchEvent(destroyEvent);

    if (m_context != EGL_NO_CONTEXT) {
        static_cast<void>(eglDestroyContext(GetDisplay(), m_context));
        m_context = EGL_NO_CONTEXT;
    }
}

EGLContext EglContextCreator::GetShareContext() const
{
    return Candera::Internal::GetEglNoContext();
}
}
