//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(EGL_CONTEXT_H)
#define EGL_CONTEXT_H

#include <CanderaPlatform/Device/Common/EGL/EglInclude.h>
#include <CanderaPlatform/Device/Common/Internal/GDU/GduContext.h>

namespace Candera
{

/** @addtogroup CommonDevice
 *  @{
 */

/**
 * @brief EglContext is an interface implemented by Egl based contexts used in GduBaseRenderTarget.
 *
 * This class is the base for both Egl based context providers and context delegators, that are
 * required to fulfill provide minimum EGLContext access.
 */

class EglContext : public GduContext
{
    public:
        typedef EGLContext ContextHandle;

        /**
         *  Retrieves the associated context.
         *  @return handle of the associated EGLContext.
         */
        virtual ContextHandle GetContext() const = 0;

    protected:

        /**
         *  Non-virtual. An object should never be destroyed from a pointer to this class.
         */
        ~EglContext() {}
};

/** @}*/ //end of CommonDevice

}

#endif //EGL_CONTEXT_PROVIDER_H
