//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(EGL_CHAIN_H)
#define EGL_CHAIN_H

#include <CanderaPlatform/Device/Common/EGL/EglInclude.h>
#include <CanderaPlatform/Device/Common/Internal/EGL/EglContext.h>

namespace Candera
{

/** @addtogroup CommonDevice
 *  @{
 */

/**
 * @brief EglChain is an interface implemented by Egl based surface providers.
 *
 * This class is the base for Egl based contexts, that are
 * required to provide surface access in addition to the requirements of EglContext.
 */

class EglChain : public EglContext
{
    public:
        /**
         *  Retrieves the associated surface config.
         *  @return handle of the associated EGLConfig.
         */
        virtual EGLConfig GetConfig() const = 0;

        /**
         *  Retrieves the surface used for reading operations.
         *  @return handle of the associated EGLSurface.
         */
        virtual EGLSurface GetReadSurface() const = 0;

        /**
         *  Retrieves the surface used for writing operations.
         *  @return handle of the associated EGLSurface.
         */
        virtual EGLSurface GetDrawSurface() const = 0;

        /**
         *  Retrieves the associated display.
         *  @return handle of the associated EGLDisplay.
         */
        virtual EGLDisplay GetDisplay() const = 0;
        
        /**
         *  Activates the EGL context. Overloads virtual method from GduContext.
         *  @return true if activation is successful
         */
        virtual bool ActivateContext();

    protected:

        /**
         *  Non-virtual. An object should never be destroyed from a pointer to this class.
         */
        ~EglChain() {}
};

/** @}*/ //end of CommonDevice

}

#endif //EGL_CHAIN_H
