//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include <CanderaPlatform/Device/Common/Internal/EGL/EglChain.h>

#include <CanderaPlatform/Device/Common/EGL/EglTraceMapper.h>
#include <CanderaPlatform/Device/Common/EGL/EglWrapper.h>

namespace Candera
{
    using namespace Internal;

bool EglChain::ActivateContext()
{
    EGLBoolean success =
        EGLWrapper::GetInstance().MakeCurrent(
            GetDisplay(),
            GetDrawSurface(),
            GetReadSurface(),
            GetContext());
    CANDERA_DEVICE_CHECK_AND_LOG_WARN(Egl, "EGLWrapper::GetInstance().MakeCurrent");
    return success == EGL_TRUE;
}
}
