//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(EGL_ANTI_ALIASED_WINDOW_SURFACE_PROPERTIES_H)
#define EGL_ANTI_ALIASED_WINDOW_SURFACE_PROPERTIES_H

#include <CanderaPlatform/Device/Common/Internal/EGL/EglWindowSurfaceProperties.h>

namespace Candera
{
/** @addtogroup CommonDevice
 *  @{
 */

/**
 * @brief EglAntiAliasedWindowSurfaceProperties exposes the properties of an EGL window surface
 * that supports anti-aliasing configured via EGL.
 *
 * EglAntiAliasedWindowSurfaceProperties extends EglWindowSurfaceProperties and exposes additional
 * anti-aliasing related properties.
 */
class EglAntiAliasedWindowSurfaceProperties : public EglWindowSurfaceProperties
{
    public:
        /**
         * Constructor
         */
        EglAntiAliasedWindowSurfaceProperties() {}

        // Properties ----------------------------------------------------------------------------------------

        void SetAntiAliasingSampleBuffers(Int value) { m_eglConfig.SetConfigurationAttribute(EglConfiguration::EglSampleBuffers, value); }
        Int GetAntiAliasingSampleBuffers() const {  return m_eglConfig.GetConfigurationAttribute(EglConfiguration::EglSampleBuffers); }

        void SetAntiAliasingMultiSamplingFactor(Int value) { m_eglConfig.SetConfigurationAttribute(EglConfiguration::EglSamples, value); }
        Int GetAntiAliasingMultiSamplingFactor() const {  return m_eglConfig.GetConfigurationAttribute(EglConfiguration::EglSamples); }

        /// @cond excluded from doxygen
        CdaForeignGduDef(EglAntiAliasedWindowSurfaceProperties)
            CdaGduProperties()
                // EGL Properties
                CdaGduProperty(AntiAliasingSampleBuffers, Int, GetAntiAliasingSampleBuffers, SetAntiAliasingSampleBuffers)
                    CdaDescription("The minimum acceptable number of multisample buffers.")
                CdaGduPropertyEnd()

                CdaGduProperty(AntiAliasingMultiSamplingFactor, Int, GetAntiAliasingMultiSamplingFactor, SetAntiAliasingMultiSamplingFactor)
                    CdaDescription("The minimum number of samples required in multisample buffers.")
                CdaGduPropertyEnd()

                CdaGduImportBaseClassProperties(EglWindowSurfaceProperties, Candera::EglWindowSurfaceProperties)

            CdaGduPropertiesEnd()
        CdaGduDefEnd()
        /// @endcond
};

/** @}*/ //end of CommonDevice
}

#endif //EGL_ANTI_ALIASED_WINDOW_SURFACE_PROPERTIES_H
