//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(BITMAPCOLORSETUP_H)
#define BITMAPCOLORSETUP_H

#include <Candera/EngineBase/Common/Bitmap.h>

namespace Candera
{

/** @addtogroup CommonDevice
 *  @{
 */

/**
 *  @brief Structure used for setting up proper Bitmap color format and type
 */
struct BitmapColorSetup {
    Bitmap::PixelFormat pixelFormat;

    BitmapColorSetup();

    BitmapColorSetup(Bitmap::PixelFormat pixelFormatValue);
    BitmapColorSetup(Int pixelFormatValue);
    BitmapColorSetup(UInt8 red, UInt8 green, UInt8 blue, UInt8 alpha);

    UInt8 GetBitsPerPixel() const;
};

/** @}*/ //end of CommonDevice

}

#endif // !defined(BITMAPCOLORSETUP_H)
