//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "BitmapColorSetup.h"

namespace Candera
{

BitmapColorSetup::BitmapColorSetup() :
    pixelFormat(Bitmap::RgbaUnsignedBytePixelFormat)
{
}

BitmapColorSetup::BitmapColorSetup(Bitmap::PixelFormat pixelFormatValue) :
    pixelFormat(pixelFormatValue)
{
}

BitmapColorSetup::BitmapColorSetup(Int pixelFormatValue) :
    pixelFormat(Bitmap::PixelFormat(pixelFormatValue))
{
}

BitmapColorSetup::BitmapColorSetup(UInt8 red, UInt8 green, UInt8 blue, UInt8 alpha) :
    pixelFormat(Bitmap::RgbaUnsignedBytePixelFormat)
{
    if ((red == 0) && (green == 0) && (blue == 0) && (alpha <= 8)) {
        pixelFormat = Bitmap::AlphaUnsignedBytePixelFormat;
    }
    //else if ((red == 0) && (green == 0) && (blue == 0) && (alpha <= 16)) {
    //    format = Bitmap::AlphaFormat;
    //    type = Bitmap::UnsignedShortType;
    //}
    else if ((red <= 5) && (green <= 6) && (blue <= 5) && (alpha == 0)) {
        pixelFormat = Bitmap::RgbUnsignedShort565PixelFormat;
    }
    else if ((red <= 8) && (green <= 8) && (blue <= 8) && (alpha == 0)) {
        pixelFormat = Bitmap::RgbUnsignedBytePixelFormat;
    }
    //else if ((red <= 16) && (green <= 16) && (blue <= 16) && (alpha == 0)) {
    //    format = Bitmap::RgbFormat;
    //    type = Bitmap::UnsignedShortType;
    //}
    else if ((red <= 5) && (green <= 5) && (blue <= 5) && (alpha <= 1)) {
        pixelFormat = Bitmap::RgbaUnsignedShort5551PixelFormat;
    }
    else if ((red <= 4) && (green <= 4) && (blue <= 4) && (alpha <= 4)) {
        pixelFormat = Bitmap::RgbaUnsignedShort4444PixelFormat;
    }
    else if ((red <= 8) && (green <= 8) && (blue <= 8) && (alpha <= 8)) {
        pixelFormat = Bitmap::RgbaUnsignedBytePixelFormat;
    }
    //else if ((red <= 16) && (green <= 16) && (blue <= 16) && (alpha <= 16)) {
    //    format = Bitmap::RgbaFormat;
    //    type = Bitmap::UnsignedShortType;
    //}
    else {
        pixelFormat = Bitmap::RgbaUnsignedBytePixelFormat;
    }
}

UInt8 BitmapColorSetup::GetBitsPerPixel() const
{

    static const Int pixelFormatCount = static_cast<Int>(Bitmap::Etc2EacCompressedSrgbaPixelFormat) + 1;
    static const UInt8 bppMap[pixelFormatCount] = {
        16, //RgbUnsignedShort565PixelFormat          
        16, //RgbaUnsignedShort4444PixelFormat        
        16, //RgbaUnsignedShort5551PixelFormat        
        16, //DepthUnsignedShortPixelFormat            
        24, //RgbUnsignedBytePixelFormat               
        32, //RgbaUnsignedBytePixelFormat              
        8,  //AlphaUnsignedBytePixelFormat          
        8,  //LuminanceUnsignedBytePixelFormat         
        16, //LuminanceAlphaUnsignedBytePixelFormat    
        0,  //CoverageUnsignedBytePixelFormat        
        0,  //Etc2CompressedRgbPixelFormat          
        0,  //Etc2CompressedSrgbPixelFormat         
        0,  //Etc2Alpha1CompressedRgbaPixelFormat    
        0,  //Etc2Alpha1CompressedSrgbaPixelFormat  
        0,  //Etc2EacCompressedRgbaPixelFormat      
        0  //Etc2EacCompressedSrgbaPixelFormat 
    };

    return bppMap[pixelFormat];
}

} //namespace Candera

