//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(GRAPHICS_PROPERTIES_H)
#define GRAPHICS_PROPERTIES_H

#include <CanderaPlatform/Device/Common/Base/GraphicDeviceUnitMetaInfo.h>

namespace Candera
{

/** @addtogroup CommonDevice
 *  @{
 */

/**
 * @brief GraphicsProperties is a base replacement class for all the properties containers.
 *
 * Does not contain any properties.
 */
class GraphicsProperties
{
    public:
        /**
         * Constructor
         */
        GraphicsProperties() {}

        /// @cond excluded from doxygen
        CdaForeignGduDef(GraphicsProperties)
            CdaGduProperties()
            CdaGduPropertiesEnd()
        CdaGduDefEnd()
        /// @endcond
};

/** @}*/ //end of CommonDevice

}

#endif //GRAPHICS_PROPERTIES_H
