//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_SURFACE_TEXT_BRUSH_CACHE_H)
    #define CANDERA_SURFACE_TEXT_BRUSH_CACHE_H

#include <CanderaPlatform/Device/Common/Effects/TextBrushCache/TextBrushCache.h>
#include <Candera/System/Mathematics/Rectangle.h>

#ifndef SURFACE_TEXT_BRUSH_CACHE_TEXT_RENDER_CONTEXT
#define SURFACE_TEXT_BRUSH_CACHE_TEXT_RENDER_CONTEXT SurfaceCacheTextRenderContext
#endif

#ifndef SURFACE_TEXT_BRUSH_CACHE_TEXT_RENDER_CONTEXT_INCLUDE
#define SURFACE_TEXT_BRUSH_CACHE_TEXT_RENDER_CONTEXT_INCLUDE <CanderaPlatform/Device/Common/Effects/TextBrushCache/SurfaceCacheTextRenderContext.h>
#endif

#include SURFACE_TEXT_BRUSH_CACHE_TEXT_RENDER_CONTEXT_INCLUDE

namespace Candera {

    class GraphicDeviceUnit;

    namespace Internal {
        /**
         *  @brief  This class represents a whole text cache. The text is drawn to
         *          a native surface, using the native API.
         *          @see Candera::TextBrushCache
         */
        class SurfaceTextBrushCache : public TextBrushCache {

            FEATSTD_TYPEDEF_BASE(TextBrushCache);

            public:

                FEATSTD_RTTI_DECLARATION();


                /**
                 *  Constructor
                 */
                SurfaceTextBrushCache();

                CANDERA_LINT_DECLARE_CLEANUP_FUNCTION(Candera::Internal::SurfaceTextBrushCache::Finalize)
                /**
                 *  Destructor
                 */
                virtual ~SurfaceTextBrushCache();

                // Overrides method from TextBrushCache.
                virtual bool Update(const TextBrushProperties& textBrushProperties, const Rectangle& textRect);
                // Overrides method from TextBrushCache.
                virtual void Render(const TextBrushProperties& textBrushProperties, const Matrix3x2& transform, const Rectangle& bound, ContextHandle2D output, Rectangle& outputArea);
                // Overrides method from TextBrushCache.
                virtual bool IsGlyphByGlyph() { return false; }

                /**
                 *  Override function in TextBrushCache.
                 *  @return The underlying TextRenderContext.
                 */
                virtual const TextRendering::TextRenderContext* GetTextRenderContext() const { return &m_textRenderContext; }

            private:
                typedef SURFACE_TEXT_BRUSH_CACHE_TEXT_RENDER_CONTEXT TextRenderContext;
                GraphicDeviceUnit* m_gdu;
                TextRenderContext m_textRenderContext;

                void Finalize();
        };
    }   // namespace Internal
}   // namespace Candera

#endif  // CANDERA_SURFACE_TEXT_BRUSH_CACHE_H
