//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_SURFACE_CACHE_TEXT_RENDER_CONTEXT_H)
    #define CANDERA_SURFACE_CACHE_TEXT_RENDER_CONTEXT_H

#include <Candera/Environment.h>
#include <Candera/TextEngine/TextEngine.h>
#include <Candera/System/Mathematics/Matrix3x2.h>
#include <Candera/System/Mathematics/Rectangle.h>
#include <CanderaPlatform/Device/Common/Base/RenderDevice2D.h>

CANDERA_UNIT_TEST_CLASS_DECLARATION(CanderaEnvironment)

namespace Candera {

    /**
     *  @brief  SurfaceGlyphCacheAccess class
     *          @see Candera::TextRendering::GlyphCacheAccess
     */
    FEATSTD_SUPPRESS_MULTI_WARNING_BEGIN(611, "not overriden because it's deprecated")
    class SurfaceGlyphCacheAccess : public TextRendering::GlyphCacheAccess {
        FEATSTD_TYPEDEF_BASE(TextRendering::GlyphCacheAccess);
        public:
            /**
             *  Constructor
             */
            SurfaceGlyphCacheAccess() : Base() {}
            /**
             *  Destructor
             */
            ~SurfaceGlyphCacheAccess() { ReleaseCache(); }

             /** 
              *  Creates a handle used to access data from the cache at a later time.
              *  The input bitmap contains a buffer stored in host memory. This buffer
              *  is not persistent, it may get destroyed after returning form calling this
              *  function. GlyphBitmap::pixels contains the address of this buffer.
              *  @param bitmap      Glyph bitmap data.
              *  @param cacheItem
              *  @return            A handle that the application may use to access
              *                     the glyph data.
              */
            virtual UInt8* Create(const TextRendering::GlyphBitmap &bitmap, UInt8* cacheItem);

            /** 
              *  Destroys a handle used to access data from the cache.
              *  @param buffer   PixelBuffer data. 
              */
            virtual void DestroyCacheItem(TextRendering::PixelBuffer buffer);

            // overrides TextRendering::GlyphCacheAccess::CheckPixelBuffer
            virtual bool CheckCacheItem(TextRendering::PixelBuffer buffer) override final;

        private:
            CANDERA_SUPPRESS_LINT_FOR_SYMBOL(1704, Candera::SurfaceGlyphCacheAccess::SurfaceGlyphCacheAccess, CANDERA_LINT_REASON_INSTANCESOBTAINABLE)
            FEATSTD_MAKE_CLASS_UNCOPYABLE(SurfaceGlyphCacheAccess);
    };
    FEATSTD_SUPPRESS_MULTI_WARNING_END()

    /**
     *  @brief  SurfaceCacheTextRenderContext class
     *          @see Candera::TextRendering::TextRenderContext
     */
    class SurfaceCacheTextRenderContext : public TextRendering::TextRenderContext {
    public:
        /**
         *  Constructor
         */
        SurfaceCacheTextRenderContext();

        /**
         *  Sets the context 2D handle.
         *  @param context2D The context 2D handle that is set.
         */
        void Set2DContext(Handle context2D);
        Handle Get2DContext() const;

        /**
         *  Retrieves the clip rectangle as a TextRect
         *  @return The current clip rectangle.
         */
        virtual const TextRendering::TextRect& GetClipRect() const;
        void SetClipRect(const TextRendering::TextRect& rect) { m_clip = rect; }

        /** 
         *  Blit the given glyph bitmap to the specified position in the render target
         *  @param x     left coordinate of the glyph bitmap
         *  @param y     top coordinate of the glyph bitmap
         *  @param glyph the glyph bitmap to be blitted
         *  @see TextRenderContext::Blit 
         */
        virtual void Blit(Int16 x, Int16 y, const TextRendering::GlyphBitmap &glyph);
        
        /**
         *  Retrieves the glyph cache access.
         *  @return The current glyph cache access
         */
        virtual TextRendering::GlyphCacheAccess* GetGlyphCacheAccess() const { return &GetSurfaceGlyphCacheAccess(); }

        /**
         *  Sets the transformation matrix.
         *  @param trans The transformation matrix that is set.
         */
        void SetTransformation(const Matrix3x2& trans) { m_transformation = trans; }

        /**
         *  Resets the updated area. The updated area is initialized with a new empty rectangle.
         */
        void ResetUpdatedArea() { m_updatedArea = Rectangle(); }

        /**
         *  Retrieves the current updated area.
         *  @return The current updated area.
         */
        const Rectangle& GetUpdatedArea() const { return m_updatedArea; }
        Rectangle& GetUpdatedArea() { return m_updatedArea; }

    private:
        CANDERA_UNIT_TEST_CLASS_FRIEND(CanderaEnvironment);

        static SurfaceGlyphCacheAccess& GetSurfaceGlyphCacheAccess();

        Handle m_context;
        Rectangle m_updatedArea;
        Matrix3x2 m_transformation;
        mutable TextRendering::TextRect m_clip;
        
    };

}   // namespace Candera

#endif  // CANDERA_SURFACE_CACHE_TEXT_RENDER_CONTEXT_H
