//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_GLYPH_TEXT_BRUSH_CACHE_H)
    #define CANDERA_GLYPH_TEXT_BRUSH_CACHE_H

#include <CanderaPlatform/Device/Common/Effects/TextBrushCache/TextBrushCache.h>
#include <CanderaPlatform/Device/Common/Effects/TextBrushCache/SurfaceCacheTextRenderContext.h>

namespace Candera {

    class Image2D;

    namespace Internal {
        /**
         *  @brief  This class creates a glyph cache, where each glyph is stored as a native surface in
         *          video memory. Drawing is done using the native API.
         *          See Candera::TextRendering::TextRenderContext
         */
        class GlyphTextBrushCache : public TextBrushCache {

            FEATSTD_TYPEDEF_BASE(TextBrushCache);

            public:

                FEATSTD_RTTI_DECLARATION();

                /**
                 *  Constructor
                 */
                GlyphTextBrushCache();

                /**
                 *  Destructor
                 */
                virtual ~GlyphTextBrushCache();

                // Overrides method from TextBrushCache.
                virtual bool Update(const TextBrushProperties& /*textBrushProperties*/, const Rectangle& /*textRect*/) { return true; }
                // Overrides method from TextBrushCache.
                virtual void Render(const TextBrushProperties& textBrushProperties, const Matrix3x2& transform, const Rectangle& bound, ContextHandle2D output, Rectangle& outputArea);
                // Overrides method from TextBrushCache.
                virtual bool IsGlyphByGlyph() { return true; }
                
                /**
                 *  Override function in TextBrushCache.
                 *  @return The underlying TextRenderContext.
                 */
                virtual const TextRendering::TextRenderContext* GetTextRenderContext() const { return &m_context; }

            private:
                SurfaceCacheTextRenderContext m_context;
        };
    }   // namespace Internal
}   // namespace Candera

#endif  // CANDERA_GLYPH_TEXT_BRUSH_CACHE_H
