//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#ifndef CANDERA_GLYPHATLASTEXTBRUSHCACHE_H
#define CANDERA_GLYPHATLASTEXTBRUSHCACHE_H

#ifdef CANDERA_2D_OVER_3D_ENABLED

#include <Candera/Engine3D/Core/GlyphAtlasTextRenderContext.h>
#include <CanderaPlatform/Device/Common/Effects/TextBrushCache/TextBrushCache.h>
#include <Candera/EngineBase/Common/GlyphAtlasCommonUtils.h>

namespace Candera
{

namespace Internal
{

class GlyphAtlasTextBrushCache : public TextBrushCache {

public:
    /**
     *  Constructor
     */
    GlyphAtlasTextBrushCache();

    /**
     *  Destructor
     */
    virtual ~GlyphAtlasTextBrushCache();

    // Overrides method from TextBrushCache.
    virtual bool Update(const TextBrushProperties& textBrushProperties, const Rectangle& textRect);

    // Overrides method from TextBrushCache.
    virtual void Render(const TextBrushProperties& textBrushProperties, const Matrix3x2& transform, const Rectangle& bound, ContextHandle2D output, Rectangle& outputArea);

    // Overrides method from TextBrushCache.
    virtual bool IsGlyphByGlyph() { return false; }

    // Overrides method from TextBrushCache.
    virtual const TextRendering::TextRenderContext* GetTextRenderContext() const override;

    //
    virtual void Unload() override;

    //
    virtual void Upload() override;

private:
    GlyphAtlasTextRenderContext m_textRenderContext;

    bool m_hasChanged;

    // -----
    Internal::GlyphAtlasBitmapUsageTracker<BitmapImage2D> m_bitmapTracker;
};

}

}

#endif

#endif
