//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_BITMAP_TEXT_BRUSH_CACHE_H)
    #define CANDERA_BITMAP_TEXT_BRUSH_CACHE_H

#include <CanderaPlatform/Device/Common/Effects/TextBrushCache/TextBrushCache.h>
#include <Candera/EngineBase/Common/BitmapTextRenderContext.h>
#include <Candera/System/Mathematics/Rectangle.h>
#include <Candera/Engine2D/Core/BitmapImage2D.h>

namespace Candera {

    class Image2D;

    namespace Internal {
        /**
         *  @brief This class represents a whole text cache. The text is drawn to
         *         a Bitmap object by a software renderer, then it is uploaded to a native surface.
         */
        class BitmapTextBrushCache : public TextBrushCache {

            FEATSTD_TYPEDEF_BASE(TextBrushCache);

            public:
                FEATSTD_RTTI_DECLARATION();

                /**
                 *  Constructor
                 */
                BitmapTextBrushCache();

                /**
                 *  Destructor
                 */
                virtual ~BitmapTextBrushCache();

                // Overrides method from TextBrushCache.
                virtual bool Update(const TextBrushProperties& textBrushProperties, const Rectangle& textRect);
                // Overrides method from TextBrushCache.
                virtual void Render(const TextBrushProperties& textBrushProperties, const Matrix3x2& transform, const Rectangle& bound, ContextHandle2D output, Rectangle& outputArea);
                // Overrides method from TextBrushCache.
                virtual bool IsGlyphByGlyph() { return false; }

                virtual const TextRendering::TextRenderContext* GetTextRenderContext() const override;

            private:

                MemoryManagement::SharedPointer<BitmapImage2D> m_bitmapImage;
        };
    }   // namespace Internal
}   // namespace Candera

#endif  // CANDERA_BITMAP_TEXT_BRUSH_CACHE_H
