//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "TextBrushBlend.h"
#include <Candera/System/MemoryManagement/MemoryManagement.h>
#include <Candera/Engine2D/Core/Image2D.h>
#include <Candera/System/Monitor/PerfMonPublicIF.h>
#include <Candera/Engine2D/Core/Camera2D.h>

namespace Candera {
    FEATSTD_RTTI_DEFINITION(TextBrushBlend, CombinedEffect2D)

    /******************************************************************************
     *  Constructor
     ******************************************************************************/
    TextBrushBlend::TextBrushBlend()
    {
    }

    TextBrushBlend::TextBrushBlend(const TextBrushBlend& rhs) : 
        Base(rhs),
        m_textBrush(rhs.m_textBrush),
        m_blendEffect(rhs.m_blendEffect)
    {
    }

    /******************************************************************************
     *  Destructor
     ******************************************************************************/
    TextBrushBlend::~TextBrushBlend()
    {
    }

    /******************************************************************************
     *  Create
     ******************************************************************************/
    TextBrushBlend::SharedPointer TextBrushBlend::Create()
    {
        CANDERA_SUPPRESS_LINT_FOR_CURRENT_SCOPE(429, CANDERA_LINT_REASON_SHAREDPOINTER)

        TextBrushBlend* brush = FEATSTD_NEW(TextBrushBlend);
        FEATSTD_DEBUG_ASSERT(brush != 0);

        TextBrushBlend::SharedPointer sharedPtr(brush);
        return sharedPtr;
    }

    /******************************************************************************
     *  Render
     ******************************************************************************/
    void TextBrushBlend::Render(SurfaceHandle /*input*/, const Rectangle& /*inputArea*/, const Matrix3x2& transform,
                                     const Node2D& node, ContextHandle2D output, Rectangle& outputArea)
    {
        CANDERA_PERF_RECORDER(Timing, (FeatStd::PerfMon::TimingRecId::RenderEffect2D, "TextBrushBlend"));

        if (m_textBrush.Text() != 0) {
            m_blendEffect.ActivateBlend(output);

            m_textBrush.ActivateColor(node, output);
            m_textBrush.RenderText(transform, output, outputArea);
            m_textBrush.DeactivateColor(output);

            m_blendEffect.DeactivateBlend(output);
        }
    }

    /******************************************************************************
     *  Upload
     ******************************************************************************/
    bool TextBrushBlend::Upload()
    {
        bool success = m_textBrush.Upload();
        success = m_blendEffect.Upload() && success;
        return success;
    }
    /******************************************************************************
     *  Unload
     ******************************************************************************/
    bool TextBrushBlend::Unload()
    {
        bool success = m_textBrush.Unload();
        success = m_blendEffect.Unload() && success;
        return success;
    }
    /******************************************************************************
     *  Update
     ******************************************************************************/
    bool TextBrushBlend::Update()
    {
        bool success = m_textBrush.Update();
        success = m_blendEffect.Update() && success;
        return success;
    }

    /******************************************************************************
     *  Clone
     ******************************************************************************/
    Effect2D::SharedPointer TextBrushBlend::Clone() const
    {
        return Effect2D::SharedPointer(CANDERA_NEW(TextBrushBlend)(*this));
    }

}   // namespace Candera
