//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "ShearBitmapBrushBlend.h"
#include <CanderaPlatform/Device/Common/Effects/ShearEffect.h>
#include <Candera/System/MemoryManagement/MemoryManagement.h>
#include <Candera/System/Mathematics/Matrix4.h>
#include <Candera/System/Monitor/PerfMonPublicIF.h>

namespace Candera {
    FEATSTD_RTTI_DEFINITION(ShearBitmapBrushBlend, CombinedEffect2D)

    /******************************************************************************
     *  Constructor
     ******************************************************************************/
    ShearBitmapBrushBlend::ShearBitmapBrushBlend()
    {
    }

    ShearBitmapBrushBlend::ShearBitmapBrushBlend(const ShearBitmapBrushBlend& rhs) :
        Base(rhs),
        m_bitmapBrush(rhs.m_bitmapBrush),
        m_shearEffect(rhs.m_shearEffect),
        m_blendEffect(rhs.m_blendEffect)
    {
    }

    /******************************************************************************
     *  Destructor
     ******************************************************************************/
    ShearBitmapBrushBlend::~ShearBitmapBrushBlend()
    {
    }

    /******************************************************************************
     *  Create
     ******************************************************************************/
    ShearBitmapBrushBlend::SharedPointer ShearBitmapBrushBlend::Create()
    {
        CANDERA_SUPPRESS_LINT_FOR_CURRENT_SCOPE(429, CANDERA_LINT_REASON_SHAREDPOINTER)

        ShearBitmapBrushBlend* brush = FEATSTD_NEW(ShearBitmapBrushBlend);
        FEATSTD_DEBUG_ASSERT(brush != 0);

        ShearBitmapBrushBlend::SharedPointer sharedPtr(brush);
        return sharedPtr;
    }

    /******************************************************************************
     *  Render
     ******************************************************************************/
    void ShearBitmapBrushBlend::Render(SurfaceHandle /*input*/, const Rectangle& /*inputArea*/, const Matrix3x2& transform,
                                            const Node2D& node, ContextHandle2D output, Rectangle& outputArea)
    {
        CANDERA_PERF_RECORDER(Timing, (Candera::PerfMon::TimingRecId::RenderEffect2D, "ShearBitmapBrushBlend"));

        Image2D* image = m_bitmapBrush.Image();

        if (image != 0) {
            m_blendEffect.ActivateBlend(output);
            Rectangle rect;
            m_bitmapBrush.GetBoundingRectangle(rect);
            static_cast<void>(image->Activate(output));
            m_shearEffect.Render(image->Get2DSurfaceHandle(), rect, transform, node, output, outputArea);
            m_blendEffect.DeactivateBlend(output);
        }
    }

    /******************************************************************************
     *  Upload
     ******************************************************************************/
    bool ShearBitmapBrushBlend::Upload()
    {
        bool success = m_bitmapBrush.Upload();
        success = m_shearEffect.Upload() && success;
        success = m_blendEffect.Upload() && success;
        return success;
    }
    /******************************************************************************
     *  Unload
     ******************************************************************************/
    bool ShearBitmapBrushBlend::Unload()
    {
        bool success = m_bitmapBrush.Unload();
        success = m_shearEffect.Unload() && success;
        success = m_blendEffect.Unload() && success;
        return success;
    }
    /******************************************************************************
     *  Update
     ******************************************************************************/
    bool ShearBitmapBrushBlend::Update()
    {
        bool success = m_bitmapBrush.Update();
        success = m_shearEffect.Update() && success;
        success = m_blendEffect.Update() && success;
        return success;
    }

    /******************************************************************************
     *  Clone
     ******************************************************************************/
    Effect2D::SharedPointer ShearBitmapBrushBlend::Clone() const
    {
        return Effect2D::SharedPointer(CANDERA_NEW(ShearBitmapBrushBlend)(*this));
    }

}   // namespace Candera
