//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_EFFECT_DATA_TYPES_H)
#define CANDERA_EFFECT_DATA_TYPES_H

#include <CanderaPlatform/Device/Common/Base/RenderDevice2D.h>
#include <Candera/System/MetaInfo/EnumDataTypeBase.h>
#include <Candera/EngineBase/DataTypes/ColorDataType.h>
#include <CanderaAssetLoader/AssetLoader2D/AssetLoader2DDataTypes.h>
#include <Candera/System/MetaInfo/DataTypeStringBufferAppenderMacros.h>

namespace Candera {
    namespace MetaInfo {

ENUM_DATA_TYPE_DEF(RenderDevice2D::BlendFactor,
    &RenderDevice2D::GetBlendFactorEditor);

ENUM_DATA_TYPE_DEF(RenderDevice2D::BlendOperation,
    &RenderDevice2D::GetBlendOperationEditor);

ENUM_DATA_TYPE_DEF(RenderDevice2D::Filter,
    &RenderDevice2D::GetFilterEditor);

ENUM_DATA_TYPE_DEF(RenderDevice2D::MipMapFilter,
    &RenderDevice2D::GetMipMapFilterEditor);

    }

}

CdaDeclareStringBufferAppender(Candera::RenderDevice2D::BlendFactor)
CdaDeclareStringBufferAppender(Candera::RenderDevice2D::BlendOperation)
CdaDeclareStringBufferAppender(Candera::RenderDevice2D::Filter)
CdaDeclareStringBufferAppender(Candera::RenderDevice2D::MipMapFilter)

#endif  // CANDERA_EFFECT_DATA_TYPES_H
