//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_COLOR_EFFECT_H)
    #define CANDERA_COLOR_EFFECT_H

#include <Candera/Engine2D/Effects/InPlaceEffect2D.h>
#include <Candera/System/MemoryManagement/SharedPointer.h>
#include <Candera/Engine2D/Property/ColorProperty.h>
#include <CanderaPlatform/Device/Common/Effects/EffectDataTypes.h>

namespace Candera {

    /**
     *  @brief  Modulate the color of an image by a constant value.
     *  There are no other applied transformations.
     */
    class ColorEffect : public InPlaceEffect2D {

        FEATSTD_TYPEDEF_BASE(InPlaceEffect2D);

    public:

        typedef MemoryManagement::SharedPointer<ColorEffect> SharedPointer;

        FEATSTD_RTTI_DECLARATION();

        /**
         *  Creates an instance of this class
         *  @return A pointer to the created object.
         */
        FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

        /**
         *  Destructor
         */
        virtual ~ColorEffect();

        /**
         *  Access the associated color. This color is used
         *  to modulate component by component each pixel of the source image.
         *  @return     A property that may be used to modify the associated color.
         */
        ColorProperty& Color() { return m_color; }

        // overrides Effect2D::Clone
        virtual Effect2D::SharedPointer Clone() const;

        /// @cond excluded from doxygen
        CdaEffect2DDef(Candera::ColorEffect, ColorEffect, EFFECT2D_TYPE_INPLACE)
            CdaEffect2DProperties()

                CdaEffect2DProperty(Color, Candera::Color, m_color)
                    CdaDescription("Constant color for modulating all input color channels (RGBA).")
                CdaEffect2DPropertyEnd()

            CdaEffect2DPropertiesEnd()
        CdaEffect2DDefEnd()
        /// @endcond

    protected:
        // Explicit protected Constructor and Copy-Constructor, use Create() to create an instance of this object.
        ColorEffect();
        explicit ColorEffect(const ColorEffect& rhs);
        ColorEffect& operator = (const ColorEffect& rhs);

        // overrides Effect2D::Render
        virtual void Render(SurfaceHandle input, const Rectangle& inputArea, const Matrix3x2& transform, const Node2D& node, ContextHandle2D output, Rectangle& outputArea);

    private:
        ColorProperty m_color;

    };

}   // namespace Candera

#endif  // CANDERA_COLOR_EFFECT_H
