//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(EGL_INVALIDE_VALUES_H)
#define EGL_INVALIDE_VALUES_H

#include <EGL/egl.h>

namespace Candera { namespace Internal {

inline EGLContext GetEglNoContext()
{
    return EGL_NO_CONTEXT;
}

inline EGLDisplay GetEglNoDisplay()
{
    return EGL_NO_DISPLAY;
}

inline EGLSurface GetEglNoSurface()
{
    return EGL_NO_SURFACE;
}

}} // namespace Internal ; namespace Candera

#undef INVALID_NATIVE_EGL_CONTEXT
#undef INVALID_NATIVE_EGL_DISPLAY
#undef INVALID_NATIVE_EGL_WINDOW

#define INVALID_NATIVE_EGL_CONTEXT  Candera::Internal::GetEglNoContext()
#define INVALID_NATIVE_EGL_DISPLAY  Candera::Internal::GetEglNoDisplay()
#define INVALID_NATIVE_EGL_WINDOW   Candera::Internal::GetEglNoSurface()

#endif /* EGL_INVALIDE_VALUES_H */
