//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERA_EGLINCLUDE_H)
#define CANDERA_EGLINCLUDE_H

#include <CONFIG/eglconfig.h>
#include <EGL/egl.h>
#include <EGL/eglext.h>


// There are some defines in the x11 headers that collide with Candera types,
// and therefore have to be undefined.
#ifdef XlibSpecificationRelease

#ifdef Bool
#undef Bool
#endif //Bool

#ifdef True
#undef True 
#endif //True

#ifdef False
#undef False 
#endif //False

#ifdef None
#undef None 
#endif //False
#endif // XlibSpecificationRelease

#include <CanderaPlatform/Device/Common/EGL/EglInvalidValues.h>
#include <Candera/Environment.h>
// this header overrides the existing defines for INVALID_NATIVE_EGL_DISPLAY and INVALID_NATIVE_EGL_WINDOW from EglInvalidValues.h
#ifdef NATIVE_EGL_INVALID_VALUES_HEADER_INCLUDE
#include NATIVE_EGL_INVALID_VALUES_HEADER_INCLUDE
#endif

// Fix MISRA warnings related to C casts in EGL macros

namespace Candera {
    namespace Internal {

inline EGLint GetEglDontCare() 
{
    return EGL_DONT_CARE;
}

inline EGLNativeDisplayType GetEglDefaultDisplay() 
{
    return static_cast<EGLNativeDisplayType>(EGL_DEFAULT_DISPLAY);
}

#undef EGL_DEFAULT_DISPLAY
#undef EGL_NO_CONTEXT
#undef EGL_NO_DISPLAY
#undef EGL_NO_SURFACE
#undef EGL_DONT_CARE

#define EGL_DEFAULT_DISPLAY     Candera::Internal::GetEglDefaultDisplay()
#define EGL_NO_CONTEXT          INVALID_NATIVE_EGL_CONTEXT
#define EGL_NO_DISPLAY          INVALID_NATIVE_EGL_DISPLAY
#define EGL_NO_SURFACE          INVALID_NATIVE_EGL_WINDOW
#define EGL_DONT_CARE           Candera::Internal::GetEglDontCare()

    } // namespace Internal
} // namespace Candera

#if defined(CGIDEVICE_OPENVG_101)
//When an OpenVG only target is present, then client version is set to default value of 1;
#define CANDERA_DEVICE_EGL_CONTEXT_CLIENT_VERSION 1
#else
//When the target has OpenGL ES support, the client version is defined in GlInclude.h
#include <CanderaPlatform/Device/Common/OpenGLES/GlInclude.h>
#endif

#endif// CANDERA_EGLINCLUDE_H
