//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "EglConfiguration.h"


namespace Candera { 

    EglConfiguration::EglConfiguration() // all attributes except the stated ones are integers
    {
        m_configuration[EglBufferSize] = 0;                                                     //           egl default: 0        
        m_configuration[EglRedSize] = 8;                                                        //           egl default: 0
        m_configuration[EglGreenSize] = 8;                                                      //           egl default: 0
        m_configuration[EglBlueSize] = 8;                                                       //           egl default: 0
        m_configuration[EglLuminanceSize] = 0;                                                  //           egl default: 0 
        m_configuration[EglAlphaSize] = 8;                                                      //           egl default: 0
        m_configuration[EglAlphaMaskSize] = 0;                                                  //           egl default: 0
        m_configuration[EglColorBufferType] = static_cast<Int32>(EglRgbBuffer);                 // enum      egl default: EglRgbBuffer
        m_configuration[EglConfigCaveat] = static_cast<Int32>(EglNoCaveat);                     // enum      egl default: EglDontCare
        m_configuration[EglConfigId] = static_cast<Int32>(EglDontCare);                         //           egl default: EglDontCare
        m_configuration[EglConformant] = 0;                                                     // bitmask   egl default: 0
        m_configuration[EglDepthSize] = 16;                                                     //           egl default: 0
        m_configuration[EglLevel] = 0;                                                          //           egl default: 0
        m_configuration[EglMaxSwapInterval] = static_cast<Int32>(EglDontCare);                  //           egl default: EglDontCare
        m_configuration[EglMinSwapInterval] = static_cast<Int32>(EglDontCare);                  //           egl default: EglDontCare
        m_configuration[EglNativeRenderable] = static_cast<Int32>(EglDontCare);                 // boolean   egl default: EglDontCare
        m_configuration[EglNativeVisualType] = static_cast<Int32>(EglDontCare);                 //           egl default: EglDontCare
        m_configuration[EglRenderableType] = static_cast<Int32>(EglRenderableTypeOpenGlEs2Bit); // bitmask   egl default: EglRenderableTypeOpenGlEsBit
        m_configuration[EglSampleBuffers] = 0;                                                  //           egl default: 0
        m_configuration[EglSamples] = 0;                                                        //           egl default: 0
        m_configuration[EglStencilSize] = 0;                                                    //           egl default: 0
        m_configuration[EglSurfaceType] = static_cast<Int32>(EglWindowBit);                     // bitmask   egl default: EglWindowBit
        m_configuration[EglTransparentType] = static_cast<Int32>(EglNoTransparency);            // enum      egl default: EglNoTransparency
        m_configuration[EglTransparentRedValue] = static_cast<Int32>(EglDontCare);              //           egl default: EglDontCare
        m_configuration[EglTransparentGreenValue] = static_cast<Int32>(EglDontCare);            //           egl default: EglDontCare
        m_configuration[EglTransparentBlueValue] = static_cast<Int32>(EglDontCare);             //           egl default: EglDontCare
        m_configuration[EglDepthEncoding] = static_cast<Int32>(EglDepthEncodingNone);           // enum      EXTENSION
        m_configuration[EglCoverageSampleBuffers] = 0;                                          //           EXTENSION
        m_configuration[EglCoverageSamples] = 0;                                                //           EXTENSION
    }
    

    EglConfiguration::~EglConfiguration()
    {
        // No instructions.
    }


    void EglConfiguration::SetConfigurationAttribute(EglConfigAttribute attribute, Int32 value)
    {
        if (attribute < EglNumberOfConfigAttributes) {
            m_configuration[attribute] = value;
        } 
        else {          
            // xxx trace
        }
    }

    Int32 EglConfiguration::GetConfigurationAttribute(EglConfigAttribute attribute) const
    {
        if (attribute < EglNumberOfConfigAttributes) {
            return m_configuration[attribute];
        } 
        else {
            return -1;
            // xxx trace
        }
    }

    

} // namespace Candera
