/* The authors of this work have released all rights to it and placed it
in the public domain under the Creative Commons CC0 1.0 waiver
(http://creativecommons.org/publicdomain/zero/1.0/).

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/
 
//########################################################################
// Source code from http://en.literateprograms.org/Median_cut_algorithm_(C_Plus_Plus)?oldid=19175 (retrieved on 2015-03-25)
// has been modified for integration by Socionext Embedded Software Austria (SESA)
//
// (C)  Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#ifndef _MEDIAN_CUT_H_
#define _MEDIAN_CUT_H_

#include <CanderaPlatform/OS/CanderaTypes.h>
  
#ifdef BUILD_FOR_PLUGIN_DLL
    #include <list>
#define VECTOR(type)\
    std::list<type>
#define VECTOR_PUSH(vector, value)\
    vector.push_back(value)
#define VECTOR_ITERATOR(type)\
    std::list<type>::iterator
#define VECTOR_BEGIN(vector)\
    vector.begin()
#define VECTOR_END(vector)\
    vector.end()

#else
    #include <Candera/System/Container/Vector.h>
#define VECTOR(type)\
    FeatStd::Internal::Vector<type>
#define VECTOR_PUSH(vector, value)\
    vector.Add(value)
#define VECTOR_ITERATOR(type)\
    FeatStd::Internal::Vector<type>::Iterator
#define VECTOR_BEGIN(vector)\
    vector.Begin()
#define VECTOR_END(vector)\
    vector.End()

#endif

const Candera::Int32 NUM_DIMENSIONS = 4;

namespace Candera {

    namespace ClutBitmapConverter {

        struct Point
        {
            UInt8 x[NUM_DIMENSIONS];
        };

        class Block
        {
        public:
            Block(Point* points, OffsetType pointsLength);
            Point * GetPoints();
            OffsetType GetNumPoints() const;
            Int32 GetLongestSideIndex() const;
            Int32 GetLongestSideLength() const;
            bool operator<(const Block& rhs) const;
            void Shrink();

        private:
            Point m_minCorner;
            Point m_maxCorner;
            Point* m_points;
            OffsetType m_pointsLength;

            template <typename T>
            static T GetMin(const T a, const T b)
            {
                if (a < b)
                    return a;
                else
                    return b;
            }

            template <typename T>
            static T GetMax(const T a, const T b)
            {
                if (a > b)
                    return a;
                else
                    return b;
            }
        };
        template <Int32 index>
        class CoordinatePointComparator
        {
        public:
            bool operator()(Point left, Point right)
            {
                return left.x[index] < right.x[index];
            }
        };

        VECTOR(Point) MedianCut(Point* image, OffsetType numPoints, SizeType desiredSize);

    }
}
#endif /* #ifndef _MEDIAN_CUT_H_ */
