//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(GENERIC_HOST_TYPE_H)
#define GENERIC_HOST_TYPE_H

#include <Candera/Environment.h>

namespace Candera
{

    namespace GenericBitmapConvertor
    {
        /**
         *  @brief Host class used to store intermediate pixel data.
         */
        template<Int Size>
        class HostTypeSelector
        {
        public:
            typedef typename HostTypeSelector<Size + 1>::Type Type;
        };

        template<> class HostTypeSelector<8 > { public: typedef UInt8  Type; };
        template<> class HostTypeSelector<16> { public: typedef UInt16 Type; };
        template<> class HostTypeSelector<32> { public: typedef UInt32 Type; };
        template<> class HostTypeSelector<64> { public: typedef UInt64 Type; };

        class HostTypeTraits
        {
        public:
            // For currently supported types, not pixel data requires more then
            // 64 bits.
            static const Int c_maxHostTypeBits = 64;
        };

    } //namespace GenericBitmapConvertor

} //namespace Candera

#endif // GENERIC_HOST_TYPE_H

