//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "GenericBitmapExtendedConvertor.h"
#include <CanderaPlatform/Device/Common/BitmapConverter/GenericBitmapFormat.h>

namespace Candera
{
    namespace GenericBitmapConvertor
    {
        ConvertorInfo GetGenericBitmapExtendedConvertorInfo(
            UInt32 dstWidth, UInt32 dstHeight,
            const GenericBitmapFormat* dstExtProp)
        {
            ConvertorInfo info;
            info.width = dstWidth;
            info.height = dstHeight;

            info.bpp = dstExtProp->GetBitsPerPixel();
            info.offset = dstExtProp->GetOffset();
            info.size = dstExtProp->GetSize();

            info.pitch = info.width * info.bpp;

            info.access = dstExtProp->GetBitmapAccess();
            info.endianness = dstExtProp->GetBitmapEndianness();

            return info;
        }

    } //namespace GenericBitmapConvertor

} //namespace Candera


