//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "GenericBitmapBaseConvertor.h"

namespace Candera
{
    namespace GenericBitmapConvertor 
    {        
        ConvertorInfo GetGenericBitmapBaseConvertorInfo(
            UInt32 dstWidth, UInt32 dstHeight, 
            Int dstPixelFormat,
            Bitmap::PackAlignment dstColorPackAllignment)
        {
            ConvertorInfo info;

            info.width = dstWidth;
            info.height = dstHeight;
            info.pitch = dstWidth;
            
            info.bpp = 0;
            info.size = 0;
            info.offset = 0;

            switch (dstPixelFormat) {
            case Bitmap::RgbUnsignedShort565PixelFormat:
                info.bpp = 16;
                info.size = 0x05060500;
                info.offset = 0x0B050000;
                break;
            case Bitmap::RgbaUnsignedShort4444PixelFormat:
                info.bpp = 16;
                info.size = 0x04040404;
                info.offset = 0x0C080400;
                break;
            case Bitmap::RgbaUnsignedShort5551PixelFormat:
                info.bpp = 16;
                info.size = 0x05050501;
                info.offset = 0x0B060100;
                break;
            case Bitmap::DepthUnsignedShortPixelFormat:
                //Cover all possible enums.
                break;
            case Bitmap::RgbUnsignedBytePixelFormat:
                info.bpp = 24;
                info.size = 0x08080800;
                info.offset = 0x00081000;
                break;
            case Bitmap::RgbaUnsignedBytePixelFormat:
                info.bpp = 32;
                info.size = 0x08080808;
                info.offset = 0x00081018;
                break;
            case Bitmap::AlphaUnsignedBytePixelFormat:
                info.bpp = 8;
                info.size = 0x00000008;
                info.offset = 0x00000000;
                break;
            case Bitmap::LuminanceUnsignedBytePixelFormat:
                info.bpp = 8;
                info.size = 0x08080800;
                info.offset = 0x00000000;
                break;
            case Bitmap::LuminanceAlphaUnsignedBytePixelFormat:
                info.bpp = 16;
                info.size = 0x08080808;
                info.offset = 0x00000008;
                break;
            case Bitmap::CoverageUnsignedBytePixelFormat:
                //Cover all possible enums.
                break;
            default:
                break;
            }

           
            
            info.pitch *= info.bpp;
            UInt32 bitAlignment = static_cast<UInt32>(dstColorPackAllignment) * 8;
            info.pitch = ((info.pitch + bitAlignment - 1) / bitAlignment) * 
                bitAlignment;

            info.access = Linear2DDirectAccess;
            info.endianness = LittleEndianBitmapWord;

            return info;
        }
        
    } //namespace GenericBitmapConvertor

} //namespace Candera


