//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#ifndef CLUT_CONVERTOR_H
#define CLUT_CONVERTOR_H

#include <Candera/Environment.h>
#include <Candera/EngineBase/Common/Bitmap.h>

#include <CanderaPlatform/Device/Common/BitmapConverter/GenericBitmapAccess.h>

#include <CanderaPlatform/Device/Common/BitmapConverter/GenericBitmapConvertor.h>

#include <CanderaPlatform/Device/Common/BitmapConverter/ClutBitmapFormat.h>

#ifdef BUILD_FOR_PLUGIN_DLL
#define ALLOC_ARRAY(type, size)\
    new type[size]
#define DELETE_ARRAY(pointer)\
    delete[] pointer
#else
#define ALLOC_ARRAY(type, size)\
    FEATSTD_NEW_ARRAY(type, size)
#define DELETE_ARRAY(pointer)\
    FEATSTD_DELETE_ARRAY(pointer)
#endif

namespace Candera
{
    class GenericBitmapFormat;

    namespace ClutBitmapConverter
    {

        //encode
        bool Convert(
            UInt32 dstWidth, UInt32 dstHeight,
            //Int dstPixelFormat,
            //Bitmap::PackAlignment dstColorPackAllignment,
            UInt8* dstBuffer, UInt32* dstBufferSize,
            const GenericBitmapFormat* dstExtProp,
            UInt32 clutData,
            UInt32 srcWidth, UInt32 srcHeight,
            Int srcPixelFormat,
            Bitmap::PackAlignment srcColorPackAllignment,
            const UInt8* srcBuffer, UInt32 srcBufferSize,
            const GenericBitmapFormat* srcExtProp,
            GenericBitmapConvertor::PixelConversionType conversionType);

        //decode
        bool Convert(
            UInt32 dstWidth, UInt32 dstHeight,
            Int dstPixelFormat,
            Bitmap::PackAlignment dstColorPackAllignment,
            UInt8* dstBuffer, UInt32* dstBufferSize,
            const GenericBitmapFormat* dstExtProp,
            UInt32 srcWidth, UInt32 srcHeight,
            const UInt8* srcBuffer);

        bool ClutConvert(
            UInt32 dstWidth, UInt32 dstHeight,
            UInt8* dstBuffer, UInt32* dstBufferSize,
            const GenericBitmapFormat* dstExtProp,
            UInt32 clutData,
            UInt32 srcWidth, UInt32 srcHeight,
            const UInt8* srcBuffer, UInt32 srcBufferSize
            );

        bool ClutConvert(
            UInt32 dstWidth, UInt32 dstHeight,
            Int dstPixelFormat,
            Bitmap::PackAlignment dstColorPackAllignment,
            UInt8* dstBuffer, UInt32* dstBufferSize,
            const GenericBitmapFormat* dstExtProp,
            UInt32 srcWidth, UInt32 srcHeight,
            Int srcPixelFormat,
            Bitmap::PackAlignment srcColorPackAllignment,
            const UInt8* srcBuffer, UInt32 srcBufferSize,
            const GenericBitmapFormat* srcExtProp);

        bool DecodeFromClut(
            UInt32 dstWidth, UInt32 dstHeight,
            Int dstPixelFormat,
            Bitmap::PackAlignment dstColorPackAllignment,
            UInt8* dstBuffer, UInt32* dstBufferSize,
            const GenericBitmapFormat* dstExtProp,
            UInt32 srcWidth, UInt32 srcHeight,
            const UInt8* srcBuffer
            );

        void GetIndexBuffer(const UInt8* clutBuffer, UInt32 clutCount, UInt16* indexBuffer,
            UInt32 width, UInt32 height, const UInt8* srcBuffer, UInt8 idxAlphaSize, UInt8 bpp);
        void GetDitheredIndexBuffer(const UInt8* clutBuffer, UInt32 clutCount, UInt16* indexBuffer,
            UInt32 width, UInt32 height, const UInt8* srcBuffer, UInt8 idxAlphaSize, UInt8 bpp);
        void GetClut(UInt8* clutBuffer, UInt32 clutCount, const UInt8* srcBuffer, UInt32 srcBufferSize, UInt32 clutAlgorithm);

        const UInt8 c_NeuQuantAlgorithm = 0;
        const UInt8 c_MedianCutAlgorithm = 1;

        class ClutParameters
        {
        public:
            UInt8 m_clutAlgorithm;
            UInt32 m_clutColorsCount;
            UInt8 m_clutIdxBytes;
            UInt8 m_clutIdxAlphaBits;

            UInt8 m_clutColorBpp;
            UInt8 m_clutColorSizeRed;
            UInt8 m_clutColorSizeGreen;
            UInt8 m_clutColorSizeBlue;
            UInt8 m_clutColorSizeAlpha;

            UInt8 m_clutDithering;

            UInt8 m_bpp;
            UInt8 m_channelSize;
            UInt8 m_size;
            
            ClutParameters() :
                m_clutAlgorithm(0),
                m_clutColorsCount(0),
                m_clutIdxBytes(0),
                m_clutIdxAlphaBits(0),
                m_clutColorBpp(0),
                m_clutColorSizeRed(0),
                m_clutColorSizeGreen(0),
                m_clutColorSizeBlue(0),
                m_clutColorSizeAlpha(0),
                m_clutDithering(0),
                m_bpp(0),
                m_channelSize(0),
                m_size(0)
            {
            
            }
            
            ClutParameters(const ClutParameters& rhs):
                m_clutAlgorithm(rhs.m_clutAlgorithm),
                m_clutColorsCount(rhs.m_clutColorsCount),
                m_clutIdxBytes(rhs.m_clutIdxBytes),
                m_clutIdxAlphaBits(rhs.m_clutIdxAlphaBits),
                m_clutColorBpp(rhs.m_clutColorBpp),
                m_clutColorSizeRed(rhs.m_clutColorSizeRed),
                m_clutColorSizeGreen(rhs.m_clutColorSizeGreen),
                m_clutColorSizeBlue(rhs.m_clutColorSizeBlue),
                m_clutColorSizeAlpha(rhs.m_clutColorSizeAlpha),
                m_clutDithering(rhs.m_clutDithering),
                m_bpp(rhs.m_bpp),
                m_channelSize(rhs.m_channelSize),
                m_size(rhs.m_channelSize)
            {
            
            }
            
            ClutParameters& operator=(const ClutParameters& rhs)
            {
                if (this == &rhs) {
                    return *this;
                }
                MemoryPlatform::Copy(this, &rhs, sizeof(ClutParameters));
                return *this;
            }


            ClutParameters(UInt32 clutData, const GenericBitmapFormat* genericFormat) :
                m_clutAlgorithm(0),
                m_clutColorsCount(0),
                m_clutIdxBytes(0),
                m_clutIdxAlphaBits(0),
                m_clutColorBpp(0),
                m_clutColorSizeRed(0),
                m_clutColorSizeGreen(0),
                m_clutColorSizeBlue(0),
                m_clutColorSizeAlpha(0),
                m_clutDithering(0),
                m_bpp(0),
                m_channelSize(0),
                m_size(0)
            {
                ClutBitmapFormat cbf(clutData, genericFormat);

                m_clutAlgorithm = cbf.GetClutAlgorithm();
                m_clutColorsCount = cbf.GetNumberOfColors();
                m_clutIdxBytes = cbf.GetBitsPerIndex()/8;
                m_clutIdxAlphaBits = cbf.GetAlphaBits();
                m_clutColorBpp = cbf.GetBitsPerPixel();
                m_clutColorSizeRed = cbf.GetRedSize();
                m_clutColorSizeGreen = cbf.GetGreenSize();
                m_clutColorSizeBlue = cbf.GetBlueSize();
                m_clutColorSizeAlpha = cbf.GetAlphaSize();
                m_clutDithering = cbf.GetDithering();

                m_bpp = m_clutIdxBytes << 3;
                m_channelSize = m_bpp - m_clutIdxAlphaBits;
                UInt32 shift8 = static_cast<UInt32>(static_cast<UInt32>(m_channelSize) << 8);
                UInt32 shift16 = (shift8 | m_channelSize) << 8;
                UInt32 shift24 = (shift16 | m_channelSize) << 8;
                m_size = static_cast<UInt8>(shift24 | m_clutIdxAlphaBits);
            }
   
   };


    } //namespace ClutBitmapConverter 

} //namespace Candera

#endif
