//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERAPLATFORM_WINDOW_H)
    #define CANDERAPLATFORM_WINDOW_H

#include <Candera/Environment.h>

namespace Candera {

/** @addtogroup CommonDevice
 *  @{
 */

/**
 * @brief Windows represent the support to which surfaces are bound. They define
 * the way the surface is laid out. The interface provides getters that describe
 * the layout of the window.
 * 
 * For display windows, the interface describes the layout of the window surface
 * on screen.
 */
class Window {
    public:

        /**
         * Destructor
         */
        virtual ~Window() {}

        /**
         *  Returns the height of the Window.
         *  @return     Height of the Window.
         */
        virtual Int GetHeight() const = 0;

        /**
         *  Returns the width of the Window.
         *  @return     Width of the Window.
         */
        virtual Int GetWidth() const = 0;

        /**
         *  Returns the X position of the Window.
         *  @return     X position of the Window.
         */
        virtual Int GetX() const = 0;

        /**
         *  Returns the Y position of the Window.
         *  @return     Y position of the Window.
         */
        virtual Int GetY() const = 0;

};

/** @}*/ //end of CommonDevice

}   // namespace Candera

#endif  // CANDERAPLATFORM_WINDOW_H
