//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "WarpMatrix.h"

namespace Candera
{

WarpMatrix::WarpMatrix() :
    m_width(0),
    m_height(0),
    m_data(0),
    m_disposer(0)
{
}
    
WarpMatrix::WarpMatrix(
    Int width, 
    Int height, 
    ConstData data, 
    ConstDataDisposerFunction disposer /*= 0*/) :
    m_width(width),
    m_height(height),
    m_data(data),
    m_disposer(disposer)
{
}
 
WarpMatrix::~WarpMatrix()
{
    ClearData();
}

void WarpMatrix::AcquireData(WarpMatrix& src)
{
    ClearData();
    
    m_width = src.m_width;
    m_height = src.m_height;
    m_data = src.m_data;
    m_disposer = src.m_disposer;
    
    src.m_width = 0;
    src.m_height = 0;
    src.m_data = 0;
    src.m_disposer = 0;
}

void WarpMatrix::ClearData()
{
    if ((m_data != 0) && (m_disposer != 0)) {
        m_disposer(m_data);
    }
    
    m_width = 0;
    m_height = 0;
    m_data = 0;
    m_disposer = 0;
}

} //namespace Candera;


