//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#include "TextureImageToImage2DAdaptor.h"
#include <CanderaPlatform/Device/Common/Base/ImageSource3D.h>

namespace Candera {
    using namespace MemoryManagement;
    FEATSTD_RTTI_DEFINITION(TextureImageToImage2DAdaptor, Image2D)

TextureImageToImage2DAdaptor::TextureImageToImage2DAdaptor() :
    m_source(),
    m_pixelFormat(),
    m_surfaceHandle()
{
}

TextureImageToImage2DAdaptor::~TextureImageToImage2DAdaptor()
{
    static_cast<void>(Unload(Force));
    m_source.Release();
}

TextureImageToImage2DAdaptor::SharedPointer TextureImageToImage2DAdaptor::Create()
{
    return SharedPointer(FEATSTD_NEW(TextureImageToImage2DAdaptor));
}

SurfaceHandle TextureImageToImage2DAdaptor::Get2DSurfaceHandle() const
{
    return m_surfaceHandle;
}

UInt32 TextureImageToImage2DAdaptor::GetWidth() const
{
    return ((m_source == 0) || (m_source->ToImageSource3D() == 0)) ? 0 : static_cast<UInt32>(m_source->ToImageSource3D()->GetWidth());
}

UInt32 TextureImageToImage2DAdaptor::GetHeight() const
{
    return ((m_source == 0) || (m_source->ToImageSource3D() == 0)) ? 0 : static_cast<UInt32>(m_source->ToImageSource3D()->GetHeight());
}

bool TextureImageToImage2DAdaptor::UploadInternal(LoadingHint loadingHint)
{
    if (m_source == 0) {
        return false;
    }
    if (!m_source->Upload()) {
        return false;
    }
    bool success = RenderDevice2D::CreateSurfaces(1, &m_surfaceHandle);
    success = success && RenderDevice2D::AttachNativeHandle(
        m_surfaceHandle,
        GetWidth(), 
        GetHeight(),
        m_pixelFormat,
        m_source->GetVideoMemoryHandle());

    if (!success) {
        (void)UnloadInternal(loadingHint);
        return false;
    }
    return true;
}

bool TextureImageToImage2DAdaptor::UnloadInternal(LoadingHint /*loadingHint*/)
{
    if (m_source != 0) {
        (void)m_source->Unload();
    }
    if (m_surfaceHandle != 0) {
        (void)RenderDevice2D::DestroySurfaces(1, &m_surfaceHandle);
        m_surfaceHandle = 0;
    }
    return true;
}


}
