//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERAPLATFORM_SURFACE_H)
    #define CANDERAPLATFORM_SURFACE_H

#include <CanderaPlatform/Device/Common/Base/Synchronizable.h>

namespace Candera {

/** @addtogroup CommonDevice
 *  @{
 */

class GraphicDeviceUnit;

/**
 *  @brief Surfaces are arbitrary image objects which map to a specified screen or off-screen boundary. Surface derived
 *  objects can be either used to draw to or used to read pixel data, typically referenced by x, and y coordinates.
 */
class Surface : public Synchronizable {
    public:
        /**
         * Constructor
         */
        Surface() : m_gdu(0)
        {
        }

        /**
         * Destructor
         */
        virtual ~Surface()
        {
        }

        /**
         *  Returns the height of the surface.
         *  @return     Height of the surface.
         */
        virtual Int GetHeight() const = 0;

        /**
         *  Returns the width of the surface.
         *  @return     Width of the surface.
         */
        virtual Int GetWidth() const = 0;

        /**
         *  Checks whether this surface is attached to a graphic device unit.
         *  @return     The graphic device unit to which this object is attached.
         *              0 if there is no such attachment.
         */
        GraphicDeviceUnit* GetGraphicDeviceUnit() const { return m_gdu; }

        /**
         *  Attach the surface to a graphic device unit.
         *  @param gdu  Graphic device unit to which this object is attached.
         */
        void SetGraphicDeviceUnit(GraphicDeviceUnit* gdu) { m_gdu = gdu; }

    private:
        GraphicDeviceUnit* m_gdu;

};

/** @}*/ //end of CommonDevice

}   // namespace Candera

#endif  // CANDERAPLATFORM_SURFACE_H
