//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERAPLATFORM_RENDERTARGET_2D_CLEARMODE_H)
    #define CANDERAPLATFORM_RENDERTARGET_2D_CLEARMODE_H

#include <FeatStd/MemoryManagement/SharedPointer.h>
#include <Candera/EngineBase/Common/Color.h>

namespace Candera {
    /** @addtogroup CommonDevice
     *  @{
     */

    /**
     * @brief Color shareable wrapper.
     *
     * A SharedClearMode2D can be associated to one or multiple
     *  RenderTarget2D instances and it will be used to clear it before the
     *  first Camera is rendered by the Renderer::RenderAllCameras method.
     */
    class SharedClearMode2D {
    public:
        typedef FeatStd::MemoryManagement::SharedPointer<SharedClearMode2D> SharedPointer;

        /**
         * @brief Create a SharedClearMode2D instance.
         *
         * The SharedClearMode2D already has a Color associated that
         *  can be retrieved or modified by calling GetClearColor().
         *
         * @return RenderTarget2DClearMode shared pointer.
         */
        FEATSTD_SHARED_POINTER_CREATE_DECLARATION();

        /**
         * @brief Retrieve the clear Color.
         *
         * @return associated clear Color.
         */
        const Color& GetClearColor() const { return m_clearColor; }
        Color& GetClearColor() { return m_clearColor; }

    private:
        Color m_clearColor;

        FEATSTD_SHARED_POINTER_DECLARATION();
    };


/** @}*/ //end of CommonDevice

}   // namespace Candera

#endif  // CANDERAPLATFORM_RENDERTARGET_3D_CLEARMODE_H
