//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################
#include "ExternalTextureImage.h"
#include <CanderaPlatform/Device/Common/Base/ContextResourcePool.h>

namespace Candera {

    ExternalTextureImage::ExternalTextureImage()
        :
        m_mipMappingEnabled(false)
    {
        m_imageSource3DInstance.SetExternalTextureImage(this);
    }

    bool ExternalTextureImage::SetMipMappingEnabled(bool enableMipMapping)
    {
        if (IsUploaded()) {
            return false;
        }
        m_mipMappingEnabled = enableMipMapping;
        return true;
    }

    bool ExternalTextureImage::IsMipMappingEnabled() const
    {
        return m_mipMappingEnabled;
    }

    Candera::ImageSource3D* ExternalTextureImage::ToImageSource3D()
    {
        return &m_imageSource3DInstance;
    }

    bool ExternalTextureImage::SetWidth(Int width)
    {
        if (IsUploaded()) {
            return false;
        }
        m_width = width;
        return true;
    }

    Int ExternalTextureImage::GetWidth() const
    {
        return m_width;
    }

    bool ExternalTextureImage::SetHeight(Int height)
    {
        if (IsUploaded()) {
            return false;
        }
        m_height = height;
        return true;
    }

    Int ExternalTextureImage::GetHeight() const
    {
        return m_height;
    }



    void ExternalTextureImage::DisposeInternal()
    {
    }

    FEATSTD_RTTI_DEFINITION(ExternalTextureImage, Base)

}
