//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERAPLATFORM_DEVICE_META_INFO_H)
    #define CANDERAPLATFORM_DEVICE_META_INFO_H

#include <Candera/System/MetaInfo/MetaInfo.h>
#include <Candera/System/MetaInfo/PublicMacros.h>
#include <CanderaPlatform/Device/Common/Base/DeviceMetaInfoHost.h>

namespace Candera {

    namespace MetaInfo {

        class DevicePropertyMetaInfo : public PropertyMetaInfo<DeviceMetaInfoHost> {
            public:
                DevicePropertyMetaInfo(const Char *name) : PropertyMetaInfo<DeviceMetaInfoHost>(name) { }
                
#ifdef CANDERA_META_DESCRIPTION

                enum {c_updateType = OnUploadUpdateType};

                /*
                 * Get UpdateType flag.
                 * @return OnUploadUpdateType as a default value for DeviceMetaInfo properties.
                 */
                virtual UpdateType GetUpdateType() const { return static_cast<PropertyMetaInfoBase::UpdateType>(c_updateType); }
#endif
        }; // class DevicePropertyMetaInfo

        class DeviceMetaInfo : public ObjectMetaInfo<DeviceMetaInfoHost, DevicePropertyMetaInfo> {
            public:
                DeviceMetaInfo(const Char* name) : ObjectMetaInfo<DeviceMetaInfoHost, DevicePropertyMetaInfo>(name) {}
                
                // default implementation, to allow creation of objects containing only meta description.
                virtual DevicePropertyMetaInfo* LookupItem(const Char *) const { return 0; }
                virtual DevicePropertyMetaInfo* GetItem(Int32) const { return 0; }
                virtual Int32 GetItemCount() const { return 0; }
        }; //class DeviceMetaInfo

    } //namespace MetaInfo
} //namespace Candera

/** Opens a host object definition section. This should reside within the body of the host object. */
#define CdaDeviceMetaInfoHostDef(typeName) \
    _CdaMetaInfoObjectProlog(typeName, typeName, Candera::DeviceMetaInfoHost, MetaInfo, Candera::MetaInfo::DeviceMetaInfo)

/** Opens a fake host object definition section. This can reside within any type of object and
    it doesn't attach properties to this object (i.e. the meta info object can't be used directly
    to set properties to this object.). Instead it creates an interface to import properties 
    defined in this scope to real hosts via chains of CdaDeviceMetaInfoHostImportProperties
    or CdaDeviceMetaInfoHostImportBaseClassProperties */
#define CdaDeviceMetaInfoFakeHostDef(typeName) \
    _CdaMetaInfoTemplateObjectProlog(typeName, typeName, Candera::DeviceMetaInfoHost, MetaInfo, Candera::MetaInfo::DeviceMetaInfo)

#define CdaDeviceMetaInfoHostDefEnd() \
    _CdaMetaInfoObjectEpilog()

/** Opens a properties definition section within a host object definition section. @see CdaDeviceMetaInfoHostDef */
#define CdaDeviceMetaInfoHostProperties() \
    _CdaPropertySetProlog(Candera::MetaInfo::DevicePropertyMetaInfo)

/** Closes a properties definition section within a host object definition section. @see CdaDeviceMetaInfoHostDef */
#define CdaDeviceMetaInfoHostPropertiesEnd() \
    _CdaPropertySetEpilog()

/** Opens a property definition section within a properties definition section. @see CdaDeviceMetaInfoHostProperties
    @param name name of the property (eg. Position)
    @param type type of the property (eg. Vector3D)
    @param getter getter function of the host object to get property value (eg. GetPosition)
    @param setter setter function of the host object to set property value (eg. SetPosition) */
#define CdaDeviceMetaInfoHostProperty(name, type, getter, setter) \
    _CdaPropertyProlog(name, type) \
    _CdaPropGetter(getter) \
    _CdaPropSetter(setter) \
    _CdaIndirectAPSFactory(name, setter, getter)

/** Imports properties from some member.
    @param name name of the import
    @param type type of the member
    @param fieldName name of the member
  */
#define CdaDeviceMetaInfoHostImportProperties(name, type, fieldName) \
    _CdaStructureImportProperties(name, type, fieldName, MetaInfo)

/** Imports properties from some base class.
    @param name name of the import
    @param type type of the base class
  */
#define CdaDeviceMetaInfoHostImportBaseClassProperties(name, type) \
    _CdaBaseClassImportProperties(name, type, MetaInfo)

/** Closes a property definition section within a properties definition section. @see CdaDeviceMetaInfoHostProperties */
#define CdaDeviceMetaInfoHostPropertyEnd() \
    _CdaPropertyEpilog()

#endif  // CANDERAPLATFORM_DEVICE_META_INFO_H
