//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################


#include "ContextProvider3D.h"
#include <CanderaPlatform/Device/Common/Base/ContextResourcePool.h>

#ifdef CANDERA_3D_ENABLED
#include <Candera/Engine3D/Core/Renderer.h>
#include <CanderaPlatform/Device/Common/Base/RenderDevice.h>
#endif

namespace Candera
{

ContextProvider3D::~ContextProvider3D()
{
    // Unsubscribe from current resource pool if not null.
    if (m_contextResourcePool != 0) {
        m_contextResourcePool->RemoveContextProvider3D(this);
        m_contextResourcePool = 0;
    }

    if (m_renderStates != 0) {
        DestroyRenderStateCache();
        m_renderStates = 0;
    }
}

bool ContextProvider3D::SetContextResourcePool(ContextResourcePool* resourcePool)
{
    if (m_contextResourcePool == resourcePool) {
        return true;
    }

    // Unsubscribe from current resource pool if not null.
    if (m_contextResourcePool != 0) {
        m_contextResourcePool->RemoveContextProvider3D(this);
    }

    m_contextResourcePool = resourcePool;

    // Subscribe to resource pool given, if not null.
    if (m_contextResourcePool != 0) {
        m_contextResourcePool->AddContextProvider3D(this);
    }

    return true;
}


void* ContextProvider3D::GetSharedContextHandle() const
{
    if (m_contextResourcePool == 0) {
        return 0;
    }
    return m_contextResourcePool->GetSharedContextHandle();
}


void ContextProvider3D::ActivateContextResourcePool()
{
    ContextResourcePool::SetActiveContextResourcePool(m_contextResourcePool);
}

} //namespace Candera


#ifdef CANDERA_3D_ENABLED

namespace Candera 
{

void ContextProvider3D::ActivateRenderStateCache() 
{ 
    RenderDevice::SetCurrentRenderStateCache(m_renderStates); 
}

bool ContextProvider3D::CreateRenderStateCache()
{
    if (m_renderStates == 0) {
        m_renderStates = RenderDevice::CreateRenderStateCache();
    }
    return m_renderStates != 0;
}

void ContextProvider3D::DestroyRenderStateCache()
{
    if(m_renderStates != 0) {
        RenderDevice::DestroyRenderStateCache(m_renderStates);
    }
    m_renderStates = 0;
}

void ContextProvider3D::OnContextUnload() const {
    if (m_contextResourcePool != 0) {
        Renderer::OnContextUnload(*m_contextResourcePool);
    }
}

} //namespace Candera

#else //ndef CANDERA_3D_ENABLED

namespace Candera {

void ContextProvider3D::ActivateRenderStateCache() 
{
    FEATSTD_LINT_NEXT_EXPRESSION(1762, "Violates MISRA C++ 2008 Required Rule 9-3-3: cannot be made const because non-const in 3D")
}

bool ContextProvider3D::CreateRenderStateCache()
{
    return true;
    FEATSTD_LINT_NEXT_EXPRESSION(1762, "Violates MISRA C++ 2008 Required Rule 9-3-3: cannot be made const because non-const in 3D")
}

void ContextProvider3D::DestroyRenderStateCache()
{
    FEATSTD_LINT_NEXT_EXPRESSION(1762, "Violates MISRA C++ 2008 Required Rule 9-3-3: cannot be made const because non-const in 3D")
}

void ContextProvider3D::OnContextUnload() const
{
}

} //namespace Candera

#endif //CANDERA_3D_ENABLED

