//########################################################################
// (C) Socionext Embedded Software Austria GmbH (SESA)
// All rights reserved.
// -----------------------------------------------------
// This document contains proprietary information belonging to
// Socionext Embedded Software Austria GmbH (SESA).
// Passing on and copying of this document, use and communication
// of its contents is not permitted without prior written authorization.
//########################################################################

#if !defined(CANDERAPLATFORM_CONTEXT_DELEGATOR_3D_H)
    #define CANDERAPLATFORM_CONTEXT_DELEGATOR_3D_H

#include <CanderaPlatform/Device/Common/Base/RenderTarget3D.h>
#include <Candera/System/Container/LinkedList.h>
#include <CanderaPlatform/Device/Common/Base/ContextResourcePool.h>

namespace Candera {

/** @addtogroup CommonDevice
 *  @{
 */

class Display;

/**
 *  @brief A ContextDelegator3D object does not have its own render context. Instead it acquires the context
 *  by associated ContextResourcePool.
 */
class ContextDelegator3D : public RenderTarget3D {
    public:
        /**
         * Constructs a ContextDelegator3D object.
         */
        ContextDelegator3D() : RenderTarget3D(0), m_contextResourcePool(0) {}

        /**
         * Destructs a ContextDelegator3D object.
         */
        virtual ~ContextDelegator3D() {}

        /**
         * Create an association to a resource pool.
         * This is done automatically when a Graphic Device Unit is uploaded.
         * @param resourcePool  Pointer to the resource pool. When 0 the
         *                      association is released.
         */
        void SetContextResourcePool(ContextResourcePool* resourcePool)
            { m_contextResourcePool = resourcePool; }

        /**
         * Get the native context handle that is currently delegated.
         * @return  The native context handle.
         */
        virtual void* GetContextHandle() const {return (m_contextResourcePool == 0) ? 0 : m_contextResourcePool->GetSharedContextHandle(); }

        /**
         * Retrieve the associated context resource pool.
         * @return  The associated context resource pool.
         */
        virtual const ContextResourcePool* GetContextResourcePool(
            ) const override final { return m_contextResourcePool; }
        using RenderTarget3D::GetContextResourcePool;

    protected:
        /**
         * Make the a context from the associated context resource pool active.
         * @return  True if successful, otherwise false.
         */
        bool ActivateContext()  { return m_contextResourcePool == 0 ? false : m_contextResourcePool->Activate(); }

    private:
        friend class ContextResourcePool;

        ContextResourcePool* m_contextResourcePool;
};

/** @}*/ //end of CommonDevice

}

#endif  // CANDERAPLATFORM_CONTEXT_DELEGATOR_3D_H
